var module = module || {};
var dataFormatter = {};
//var db = require ('./db/workingDatabase').db;
//var workingEvents = require('./db/workingEvents');
var db = require ('./db/workingDatabase1').db;
var workingEvents = require('./db/workingEvents1');
var incr = 0;

// format of sensor data
//-------------------------------
// doc = [ { id: 'rasp1',
//   time: '2014-09-18T14:33:52.000Z',
//   count: 79,
//   label: 'BC:F5:AC:F5:E1:99',
//   zone: 'zoneA',
//   topic: 'SENSOR/WIFI/IN'} ]

function formatDevicesDay(docs){
    var timeList = [];
    var object = []
    if (docs){
        incr = 0;
        var graphDataFormatEntrancesDay = 
          {
            "color" : "lightblue",
            "name" : "Registered devices",
            "data" : []
          }      
   
        docs.forEach(function(doc){  
            var time = new Date(doc.time).toString().split(" ")[4];//.slice(0,2);
            var data = {
              "x": incr,//parseInt(time),
              "y": doc.count                            
            }
            graphDataFormatEntrancesDay.data.push(data);      
            timeList.push(time);  
          //console.log("time ", time);        
            incr++;                        
        });               
    }
    return graphDataFormatEntrancesDay;
}


dataFormatter.formatDevicesDay = formatDevicesDay;


function formatDevicesMonth(docs){
    var days= [];
    var mediumCount = 0, totalDayCount = 0;
    var i = 0;
    var firstDayinDoc = "true";
    var globalDay = 0, globalCount = 0;

    if (docs){
        incr = 0;
        var graphDataFormatEntrancesMonth = 
            {
              "color" : "steelblue",
              "name" : "Average number of devices per day",
              "data" : []
            } 

        docs.forEach(function(doc){
          var day = new Date(doc.time).toString().split(" ")[2];
          //days.indexOf(day) != -1 ? console.log("same day") : console.log("new day")

          // Case 1: If this is a record from the same day that already exists in the days list
          // then only sum the count number                    

          if (days.indexOf(day) !=  -1) {
            i++;
            totalDayCount = totalDayCount + doc.count;
            mediumCount = Math.round( totalDayCount / i * 10 ) / 10;
            globalDay = day;
            globalCount = mediumCount;

          // Case 2: first day registered in the first record
          // it enters only once here

          } else if (firstDayinDoc == "true") {
            firstDayinDoc = "false";
            i++;
            totalDayCount = totalDayCount + doc.count;
            days.push(day);

          // Case 3: record in the list for a new day
          } else {           
              i++;
              totalDayCount = totalDayCount + doc.count;
              mediumCount = Math.round( totalDayCount / i * 10 ) / 10;
              //console.log("mc1 ", mediumCount);
              var data = {
                  "x": parseInt(day)-1,
                  "y": mediumCount
              }
              graphDataFormatEntrancesMonth.data.push(data);  
                
                i = 0;
                mediumCount = 0;
                totalDayCount = 0;
                days.push(day);               
          }   
          incr++;              
        });
        // Case 4: If the retrieved list contains only data for one day
        // it will exit from case 1 and data will be empty

        if (graphDataFormatEntrancesMonth.data == "") {
            var data = {
                  "x": parseInt(globalDay),
                  "y": globalCount
              }
              graphDataFormatEntrancesMonth.data.push(data);  
        }        
    }  
    return  graphDataFormatEntrancesMonth;
}

dataFormatter.formatDevicesMonth = formatDevicesMonth;


function formatRealtime(docs){  
 
  if (docs){
      incr = 0;
      var graphDataFormatDailyEntrancesExits = 
        {
            "color" : "steelblue",
            "name" : "Registered devices",
            "data" : []
          }              

      docs.forEach(function(doc){    
        var data = {
          "x": incr,
          "y": (doc.topic == 'SENSOR/WIFI/IN') ? 3 : 1
        }
        graphDataFormatDailyEntrancesExits.data.push(data); 
        incr++;                             
      });        
  }
  return graphDataFormatDailyEntrancesExits; 
}

dataFormatter.formatRealtime = formatRealtime;


function formatRealtimeEvents(docs){  
  var ins = docs.ins;
  var outs = docs.outs;
  var devices = {};
 
  if (ins || outs){
      incr1 = 0;
      incr2 = 0;
      var devicesIn = 
        {
            "color" : "#98fb98",
            "name" : "Event IN, devices number",
            "data" : []
        }              

      var devicesOut = 
        {
            "color" : "#6aaf6a",
            "name" : "Event OUT devices number",
            "data" : []
        }  

      ins.forEach(function(doc){    
        var data = {
          "x": incr1,
          "y": doc.count
        }
        devicesIn.data.push(data); 
        incr1++; 
      }); 
      
      outs.forEach(function(doc){    
        var data = {
          "x": incr2,
          "y": doc.count
        }
        devicesOut.data.push(data);  
        incr2++;                             
      }); 

     devices.devicesIn = devicesIn;
     devices.devicesOut = devicesOut;   
  } 
    return devices;
}

dataFormatter.formatRealtimeEvents = formatRealtimeEvents;


function formatBusyDays(docs, count){  
 var days = [];
 var mediumCount = 0, totalDayCount = 0;
    var i = 0;
    var firstDayinDoc = "true";
    var globalDay = 0, globalCount = 0;

  if (docs){
      incr = 1; 
      var graphDataFormatDaysIncreasedTraffic = {
        "color" : "#C67171",
        "name" : "Days with devices above the specified limit",
        "data" : []
      }      

      docs.forEach(function(doc){

          var day = new Date(doc.time).toString().split(" ")[2];
          
          // if (daysList.indexOf(day) ==  -1) {
          //   //console.log("day ", day);
          //   //console.log("count ", doc.count);
          //   daysList.push(day);
          //   var data = {
          //       "x": parseInt(day),
          //       "y": doc.count//incr
          //   }
          //   graphDataFormatDaysIncreasedTraffic.data.push(data);
          //   incr++;  
          // } 

          if (days.indexOf(day) !=  -1) {
            i++;
            totalDayCount = totalDayCount + doc.count;
            mediumCount = Math.round( totalDayCount / i * 10 ) / 10;
            globalDay = day;
            globalCount = mediumCount;

          // Case 2: first day registered in the first record
          // it enters only once here

          } else if (firstDayinDoc == "true") {
            firstDayinDoc = "false";
            i++;
            totalDayCount = totalDayCount + doc.count;
            days.push(day);

          // Case 3: record in the list for a new day
          } else {           
              i++;
              totalDayCount = totalDayCount + doc.count;
              mediumCount = Math.round( totalDayCount / i * 10 ) / 10;
              //console.log("mc1 ", mediumCount);
              if (mediumCount >= count) {
                var data = {
                  "x": parseInt(day)-1,
                  "y": mediumCount
                }
                graphDataFormatDaysIncreasedTraffic.data.push(data); 
              }
                              
              i = 0;
              mediumCount = 0;
              totalDayCount = 0;
              days.push(day);               
          }   
          incr++;                    
                                     
      });  

      if (graphDataFormatDaysIncreasedTraffic.data == "") {

          if (mediumCount <= count) {
                var data = {
                  "x": parseInt(globalDay),
                  "y": globalCount
                }
                graphDataFormatDaysIncreasedTraffic.data.push(data); 
          }
      }

  }                       
  return graphDataFormatDaysIncreasedTraffic; 
}

dataFormatter.formatBusyDays = formatBusyDays;

module.exports = dataFormatter;  





