var CODEditor = CODEditor || {};
CODEditor.Viewer = true;
CODEditor.File = {"type":"test","title":"Calculator","exercises":"[{\"type\":\"exercise\",\"title\":\"Introduction\",\"description\":\"This is a very simple calculator that can only do additions with 2 arguments.\\nPressing the button <b>Run code</b> (play) you can see the HTML page.\\nPressing the title <b>Calculator</b> or the selector you can access the different exercises of this self-graded exercise.\\nPress the button <b>Run Code</b>, test the calculator and go to the next step.\",\"editorMode\":\"HTML\",\"content\":\"<!DOCTYPE html>\\n<html>\\n<head>\\n\\t<title>Calculator</title>\\n\\t<meta charset=\\\"utf-8\\\">\\n  <script libname=\\\"jquery\\\" src=\\\"https://code.jquery.com/jquery-1.11.2.min.js\\\"></script>\\n</head>\\n<body>\\n\\n\\t<div>\\n\\t\\tNumber: <input type=\\\"text\\\" id=\\\"screen\\\"/>\\n\\t\\t<button id=\\\"add\\\">+</button>\\n\\t\\t<button id=\\\"equals\\\">=</button>\\n\\t</div>\\n\\n\\t<script type=\\\"text/javascript\\\">\\n\\t\\tvar acc = 0;\\n\\t\\tvar op;\\n\\n\\t\\t$(document).ready(function(){ \\n\\t\\t\\t$(\\\"#screen\\\").click(function(){\\n\\t\\t\\t\\t$(this).val(\\\"\\\");\\n\\t\\t\\t});\\n\\t\\t\\t$(\\\"#add\\\").click(function(){\\n\\t\\t\\t\\tacc = parseFloat($(\\\"#screen\\\").val());\\n\\t\\t\\t\\top = \\\"+\\\";\\n\\t\\t\\t});\\n\\t\\t\\t$(\\\"#equals\\\").click(function(){\\n\\t\\t\\t\\tvar n = parseFloat($(\\\"#screen\\\").val());\\n\\t\\t\\t\\tif(op === \\\"+\\\"){\\n\\t\\t\\t\\t\\tacc += n;\\n\\t\\t\\t\\t} else {\\n\\t\\t\\t\\t\\tacc = n;\\n\\t\\t\\t\\t}\\n\\t\\t\\t\\t$(\\\"#screen\\\").val(acc);\\n\\t\\t\\t\\tacc = 0;\\n\\t\\t\\t\\top = undefined;\\n\\t\\t\\t});\\n\\t\\t});\\n\\t</script>\\n</body>\\n</html>\",\"progress\":{\"score\":0,\"passed\":false}},{\"type\":\"exercise\",\"title\":\"a) HTML tags\",\"description\":\"Add a header to the HTML document (with the <code><header></code> tag) with identifier \\\"myheader\\\", class \\\"big\\\", an attribute \\\"title\\\" with value \\\"Main header\\\" and content \\\"Welcome to my calculator\\\"\",\"editorMode\":\"HTML\",\"content\":\"<!DOCTYPE html>\\n<html>\\n<head>\\n\\t<title>Calculator</title>\\n\\t<meta charset=\\\"utf-8\\\">\\n  <script libname=\\\"jquery\\\" src=\\\"https://code.jquery.com/jquery-1.11.2.min.js\\\"></script>\\n</head>\\n<body>\\n\\n\\t<div>\\n\\t\\tNumber: <input type=\\\"text\\\" id=\\\"screen\\\"/>\\n\\t\\t<button id=\\\"add\\\">+</button>\\n\\t\\t<button id=\\\"equals\\\">=</button>\\n\\t</div>\\n\\n\\t<script type=\\\"text/javascript\\\">\\n\\t\\tvar acc = 0;\\n\\t\\tvar op;\\n\\n\\t\\t$(document).ready(function(){ \\n\\t\\t\\t$(\\\"#screen\\\").click(function(){\\n\\t\\t\\t\\t$(this).val(\\\"\\\");\\n\\t\\t\\t});\\n\\t\\t\\t$(\\\"#add\\\").click(function(){\\n\\t\\t\\t\\tacc = parseFloat($(\\\"#screen\\\").val());\\n\\t\\t\\t\\top = \\\"+\\\";\\n\\t\\t\\t});\\n\\t\\t\\t$(\\\"#equals\\\").click(function(){\\n\\t\\t\\t\\tvar n = parseFloat($(\\\"#screen\\\").val());\\n\\t\\t\\t\\tif(op === \\\"+\\\"){\\n\\t\\t\\t\\t\\tacc += n;\\n\\t\\t\\t\\t} else {\\n\\t\\t\\t\\t\\tacc = n;\\n\\t\\t\\t\\t}\\n\\t\\t\\t\\t$(\\\"#screen\\\").val(acc);\\n\\t\\t\\t\\tacc = 0;\\n\\t\\t\\t\\top = undefined;\\n\\t\\t\\t});\\n\\t\\t});\\n\\t</script>\\n</body>\\n</html>\",\"progress\":{\"score\":0,\"passed\":false},\"score_function\":\"var score = function(document){\\n  var grade = {};\\n  grade.successes = [];\\n  grade.errors = [];\\n  grade.feedback = [];\\n  grade.score = 0;\\n  \\n  //Is there a <header>.\\n\\tif($(document).find(\\\"header\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"There is no <header> tag.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tif($(document).find(\\\"body header\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"<header> should be inside <body>.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tif($(document).find(\\\"body header#myheader\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"<header> should have identifier 'myheader'.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tif($(document).find(\\\"body header#myheader.big\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"<header> should have class 'big'.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tif($(document).find(\\\"body header#myheader.big[title]\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"<header> should have attribute 'title'.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tif($(document).find(\\\"body header#myheader.big[title='Main header']\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"<header> should have a 'title' attribute with value 'Main header'.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tvar header = $(document).find(\\\"body header#myheader.big[title='Main header']\\\");\\n\\tvar headerContent = $(header).html();\\n\\t\\n\\tif(headerContent.replace(/ +/g,\\\"\\\").toLowerCase().indexOf(\\\"welcometomycalculator\\\")==-1){\\n\\t  grade.errors.push(\\\"The content of the <header> should be 'Welcome to my calculator'.\\\");\\n\\t  return grade;\\n\\t}\\n\\t\\n  grade.score = 10;\\n  grade.successes.push(\\\"Perfect.\\\");\\n\\n  return grade;\\n};\"},{\"type\":\"exercise\",\"title\":\"b)  CSS styles\",\"description\":\"Complete and modify the content of the <code><style type=\\\"text/css\\\"></code> tag<b> without modifying the DOM tree of the page</b> so that:\\n* The screen of the calculator has a black background but the numbers are shown in white.\\n* All buttons inside <code><div class=\\\"calculator keyboard\\\"></code> have black background and white font.\\n* All buttons inside <code><div class=\\\"calculator keyboard\\\"></code> with an attribute \\\"operation\\\" equals to \\\"true\\\" have a blue border.\\n* All inputs of type text (including the screen) have a red border when their containing <div> has class \\\"error\\\"\",\"editorMode\":\"HTML\",\"content\":\"<!DOCTYPE html>\\n<html>\\n<head>\\n\\t<title>Calculator</title>\\n\\t<meta charset=\\\"utf-8\\\">\\n  <script libname=\\\"jquery\\\" src=\\\"https://code.jquery.com/jquery-1.11.2.min.js\\\"></script>\\n  <style type=\\\"text/css\\\">\\n\\t  /* Write your solution here */\\n\\t  #screen {\\n\\t    background: white;\\n\\t  }\\n\\t</style>\\n</head>\\n<body>\\n\\n\\t<div class=\\\"calculator keyboard\\\">\\n\\t\\tNumber: <input type=\\\"text\\\" id=\\\"screen\\\"/>\\n\\t\\t<button id=\\\"add\\\" operation=\\\"true\\\">+</button>\\n\\t\\t<button id=\\\"equals\\\">=</button>\\n\\t</div>\\n\\n\\t<script type=\\\"text/javascript\\\">\\n\\t\\tvar acc = 0;\\n\\t\\tvar op;\\n\\n\\t\\t$(document).ready(function(){ \\n\\t\\t\\t$(\\\"#screen\\\").click(function(){\\n\\t\\t\\t\\t$(this).val(\\\"\\\");\\n\\t\\t\\t});\\n\\t\\t\\t$(\\\"#add\\\").click(function(){\\n\\t\\t\\t\\tacc = parseFloat($(\\\"#screen\\\").val());\\n\\t\\t\\t\\top = \\\"+\\\";\\n\\t\\t\\t});\\n\\t\\t\\t$(\\\"#equals\\\").click(function(){\\n\\t\\t\\t\\tvar n = parseFloat($(\\\"#screen\\\").val());\\n\\t\\t\\t\\tif(op === \\\"+\\\"){\\n\\t\\t\\t\\t\\tacc += n;\\n\\t\\t\\t\\t} else {\\n\\t\\t\\t\\t\\tacc = n;\\n\\t\\t\\t\\t}\\n\\t\\t\\t\\t$(\\\"#screen\\\").val(acc);\\n\\t\\t\\t\\tacc = 0;\\n\\t\\t\\t\\top = undefined;\\n\\t\\t\\t});\\n\\t\\t});\\n\\t</script>\\n</body>\\n</html>\",\"progress\":{\"score\":0,\"passed\":false},\"score_function\":\"var score = function(document){\\n  var grade = {};\\n  grade.successes = [];\\n  grade.errors = [];\\n  grade.feedback = [];\\n  grade.score = 0;\\n  \\n  //Replace content\\n  if((typeof document != \\\"undefined\\\")&&(typeof document.documentElement != \\\"undefined\\\")){\\n    var bodyContent = '<div class=\\\"calculator keyboard\\\"> Number: <input type=\\\"text\\\" id=\\\"screen\\\"> <button id=\\\"add\\\" operation=\\\"true\\\">+</button> <button id=\\\"equals\\\">=</button> <input id=\\\"test6\\\" operation=\\\"true\\\" style=\\\"display:none\\\"> </div> <div id=\\\"test1\\\" class=\\\"calculator\\\" style=\\\"display:none\\\"> <input> <button>b</button> <button operation=\\\"true\\\">op</button> </div> <div id=\\\"test2\\\" class=\\\"keyboard\\\" style=\\\"display:none\\\"> <input> <button>b</button> <button operation=\\\"true\\\">op</button> </div> <article id=\\\"test3\\\" class=\\\"calculator keyboard\\\" style=\\\"display:none\\\"> <input> <button>b</button> <button operation=\\\"true\\\">op</button> </article> <div id=\\\"test4\\\" class=\\\"error\\\" style=\\\"display:none\\\"> <input type=\\\"text\\\"> <input type=\\\"number\\\"> <div type=\\\"text\\\"></div> </div> <article id=\\\"test5\\\" class=\\\"error\\\" style=\\\"display:none\\\"> <input type=\\\"text\\\"> <input type=\\\"number\\\"> <div type=\\\"text\\\"></div> </article> <script type=\\\"text/javascript\\\"> var acc = 0; var op; $(document).ready(function(){ $(\\\"#screen\\\").click(function(){ $(this).val(\\\"\\\"); }); $(\\\"#add\\\").click(function(){ acc = parseFloat($(\\\"#screen\\\").val()); op = \\\"+\\\"; }); $(\\\"#equals\\\").click(function(){ var n = parseFloat($(\\\"#screen\\\").val()); if(op === \\\"+\\\"){ acc += n; } else { acc = n; } $(\\\"#screen\\\").val(acc); acc = 0; op = undefined; }); }); </script>';\\n    $(document).find(\\\"body\\\").html(bodyContent);\\n    \\n    //Restore events\\n    $(document).find(\\\"#screen\\\").click(function(){\\n\\t\\t\\t$(this).val(\\\"\\\");\\n\\t\\t});\\n\\t\\t$(document).find(\\\"#add\\\").click(function(){\\n\\t\\t\\tacc = parseFloat($(document).find(\\\"#screen\\\").val());\\n\\t\\t\\top = \\\"+\\\";\\n\\t\\t});\\n\\t\\t$(document).find(\\\"#equals\\\").click(function(){\\n\\t\\t\\tvar n = parseFloat($(document).find(\\\"#screen\\\").val());\\n\\t\\t\\tif(op === \\\"+\\\"){\\n\\t\\t\\t\\tacc += n;\\n\\t\\t\\t} else {\\n\\t\\t\\t\\tacc = n;\\n\\t\\t\\t}\\n\\t\\t\\t$(document).find(\\\"#screen\\\").val(acc);\\n\\t\\t\\tacc = 0;\\n\\t\\t\\top = undefined;\\n\\t\\t});\\n  }\\n  \\n  //Tests\\n\\tif($(document).find(\\\"#screen\\\").css(\\\"background-color\\\") != \\\"rgb(0, 0, 0)\\\"){\\n\\t  \\tgrade.errors.push(\\\"Calculator screen should have background black.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tif($(document).find(\\\"#screen\\\").css(\\\"color\\\") != \\\"rgb(255, 255, 255)\\\"){\\n\\t  \\tgrade.errors.push(\\\"screen should show text in white color.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\t\\n\\tif($(document).find(\\\"input\\\").not(\\\"#screen\\\").css(\\\"background-color\\\") == \\\"rgb(0, 0, 0)\\\"){\\n\\t  \\tgrade.errors.push(\\\"Only screen <input> should be black.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\t\\n\\tif($(document).find(\\\"input\\\").not(\\\"#screen\\\").css(\\\"color\\\") == \\\"rgb(255, 255, 255)\\\"){\\n\\t  grade.errors.push(\\\"Only screen <input> should have white text.\\\");\\n\\t  return grade;\\n\\t}\\n\\t\\n\\tif($(document).find(\\\"div.calculator.keyboard button\\\").css(\\\"background-color\\\") != \\\"rgb(0, 0, 0)\\\"){\\n\\t  \\tgrade.errors.push(\\\"All buttons inside <div class=\\\\\\\"calculator keyboard\\\\\\\">  should have black background.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\t\\n\\tif($(document).find(\\\"div.calculator.keyboard button\\\").css(\\\"color\\\") != \\\"rgb(255, 255, 255)\\\"){\\n\\t  \\tgrade.errors.push(\\\"All buttons inside <div class=\\\\\\\"calculator keyboard\\\\\\\"> should have white font.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tif($(document).find(\\\"div.calculator.keyboard button[operation='true']\\\").css(\\\"border-top-color\\\") != \\\"rgb(0, 0, 255)\\\"){\\n\\t  \\tgrade.errors.push(\\\"All buttons inside <div class=\\\\\\\"calculator keyboard\\\\\\\"> with attribute \\\\\\\"operation\\\\\\\" equals \\\\\\\"true\\\\\\\" should have blue border.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\t\\n\\t//Check CSS double class selector\\n\\tif($(document).find(\\\"div#test2.keyboard button\\\").css(\\\"background-color\\\") == \\\"rgb(0, 0, 0)\\\"){\\n\\t  \\tgrade.errors.push(\\\"The CSS selector to apply the style to all buttons inside <div class=\\\\\\\"calculator keyboard\\\\\\\"> is not right.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tif($(document).find(\\\"div#test2.keyboard button\\\").css(\\\"color\\\") == \\\"rgb(255, 255, 255)\\\"){\\n\\t  \\tgrade.errors.push(\\\"The CSS selector to apply the style to all buttons inside <div class=\\\\\\\"calculator keyboard\\\\\\\"> is not right.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tif($(document).find(\\\"div#test2.keyboard button[operation='true']\\\").css(\\\"border-top-color\\\") == \\\"rgb(0, 0, 255)\\\"){\\n      grade.errors.push(\\\"The CSS selector to apply the style to all buttons inside <div class=\\\\\\\"calculator keyboard\\\\\\\">  with attribute 'operation' is not right.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\t\\n\\tif($(document).find(\\\"div#test1.calculator button\\\").css(\\\"background-color\\\") == \\\"rgb(0, 0, 0)\\\"){\\n      grade.errors.push(\\\"The CSS selector to apply the style to all buttons inside <div class=\\\\\\\"calculator keyboard\\\\\\\"> is not right.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tif($(document).find(\\\"div#test1.calculator button\\\").css(\\\"color\\\") == \\\"rgb(255, 255, 255)\\\"){\\n      grade.errors.push(\\\"The CSS selector to apply the style to all buttons inside <div class=\\\\\\\"calculator keyboard\\\\\\\"> is not right.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tif($(document).find(\\\"div#test1.calculator button[operation='true']\\\").css(\\\"border-top-color\\\") == \\\"rgb(0, 0, 255)\\\"){\\n      grade.errors.push(\\\"The CSS selector to apply the style to all buttons inside <div class=\\\\\\\"calculator keyboard\\\\\\\"> is not right.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\t\\n\\tif($(document).find(\\\"article#test3.calculator.keyboard button\\\").css(\\\"background-color\\\") == \\\"rgb(0, 0, 0)\\\"){\\n      grade.errors.push(\\\"The CSS selector to apply the style to all buttons inside <div class=\\\\\\\"calculator keyboard\\\\\\\"> is not right.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tif($(document).find(\\\"article#test3.calculator.keyboard button\\\").css(\\\"color\\\") == \\\"rgb(255, 255, 255)\\\"){\\n      grade.errors.push(\\\"The CSS selector to apply the style to all buttons inside <div class=\\\\\\\"calculator keyboard\\\\\\\"> is not right.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tif($(document).find(\\\"article#test3.calculator.keyboard button[operation='true']\\\").css(\\\"color\\\") == \\\"rgb(0, 0, 255)\\\"){\\n    grade.errors.push(\\\"The CSS selector to apply the style to all buttons inside <div class=\\\\\\\"calculator keyboard\\\\\\\">  with attribute 'operation' is not right.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\t\\n\\tif($(document).find(\\\"div.calculator.keyboard button[operation!='true']\\\").css(\\\"border-top-color\\\") == \\\"rgb(0, 0, 255)\\\"){\\n    grade.errors.push(\\\"The CSS selector to apply the style to all buttons inside <div class=\\\\\\\"calculator keyboard\\\\\\\">  with attribute 'operation' is not right.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tif($(document).find(\\\"div.calculator.keyboard input#test6[operation='true']\\\").css(\\\"border-top-color\\\") == \\\"rgb(0, 0, 255)\\\"){\\n      grade.feedback.push()\\t     \\n      grade.errors.push(\\\"The CSS selector to apply the style to all buttons inside <div class=\\\\\\\"calculator keyboard\\\\\\\">  with attribute 'operation' is not right.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\t\\n\\tif($(document).find(\\\"div input[type='text']\\\").css(\\\"border-top-color\\\") == \\\"rgb(255, 0, 0)\\\"){\\n\\t  \\tgrade.errors.push(\\\"Inputs should only have a red border if their containing <div> has class \\\\\\\"error\\\\\\\".\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\t\\n\\tif($(document).find(\\\"div#test4.error input[type='text']\\\").css(\\\"border-top-color\\\") != \\\"rgb(255, 0, 0)\\\"){\\n    grade.errors.push(\\\"Inputs should only have a red border if their containing <div> has class \\\\\\\"error\\\\\\\".\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\t\\n\\tif($(document).find(\\\"article#test5.error input[type='text']\\\").css(\\\"border-top-color\\\") == \\\"rgb(255, 0, 0)\\\"){\\n    grade.errors.push(\\\"Inputs should only have a red border if their containing <div> has class \\\\\\\"error\\\\\\\".\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\t\\n\\tif($(document).find(\\\"div#test4.error input[type!='text']\\\").css(\\\"border-top-color\\\") == \\\"rgb(255, 0, 0)\\\"){\\n    grade.errors.push(\\\"Inputs should only have a red border if their are text type\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\t\\n\\tif($(document).find(\\\"div#test4.error div[type='text']\\\").css(\\\"border-top-color\\\") == \\\"rgb(255, 0, 0)\\\"){\\n    grade.errors.push(\\\"Only inputs and no other elements should only have a red border if their containing <div> has class \\\\\\\"error\\\\\\\".\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\n  grade.score = 10;\\n  grade.successes.push(\\\"Right.\\\");\\n\\n  return grade;\\n};\"},{\"type\":\"exercise\",\"title\":\"c)  Error management\",\"description\":\"Modify the calculator so that when any of the arguments introduced are a text instead of a number, it shows in the screen the message <b>'Error'</b>.\",\"editorMode\":\"HTML\",\"content\":\"<!DOCTYPE html>\\n<html>\\n<head>\\n\\t<title>Calculator</title>\\n\\t<meta charset=\\\"utf-8\\\">\\n  <script libname=\\\"jquery\\\" src=\\\"https://code.jquery.com/jquery-1.11.2.min.js\\\"></script>\\n</head>\\n<body>\\n\\n\\t<div>\\n\\t\\tNumber: <input type=\\\"text\\\" id=\\\"screen\\\"/>\\n\\t\\t<button id=\\\"add\\\">+</button>\\n\\t\\t<button id=\\\"equals\\\">=</button>\\n\\t</div>\\n\\n\\t<script type=\\\"text/javascript\\\">\\n\\t\\tvar acc = 0;\\n\\t\\tvar op;\\n\\n\\t\\t$(document).ready(function(){\\n\\t\\t\\t$(\\\"#screen\\\").click(function(){\\n\\t\\t\\t\\t$(this).val(\\\"\\\");\\n\\t\\t\\t});\\n\\t\\t\\t$(\\\"#add\\\").click(function(){\\n\\t\\t\\t\\tacc = parseFloat($(\\\"#screen\\\").val());\\n\\t\\t\\t\\top = \\\"+\\\";\\n\\t\\t\\t});\\n\\t\\t\\t$(\\\"#equals\\\").click(function(){\\n\\t\\t\\t\\tvar n = parseFloat($(\\\"#screen\\\").val());\\n\\t\\t\\t\\tif(op === \\\"+\\\"){\\n\\t\\t\\t\\t\\tacc += n;\\n\\t\\t\\t\\t} else {\\n\\t\\t\\t\\t\\tacc = n;\\n\\t\\t\\t\\t}\\n\\t\\t\\t\\t$(\\\"#screen\\\").val(acc);\\n\\t\\t\\t\\tacc = 0;\\n\\t\\t\\t\\top = undefined;\\n\\t\\t\\t});\\n\\t\\t});\\n\\t</script>\\n</body>\\n</html>\",\"progress\":{\"score\":0,\"passed\":false},\"score_function\":\"var score = function(document){\\n  var grade = {};\\n  grade.score = 0;\\n  grade.successes = [];\\n  grade.errors = [];\\n  grade.feedback = [];\\n\\n  //Content\\n  var content;\\n  if((typeof document != \\\"undefined\\\")&&(typeof document.documentElement != \\\"undefined\\\")){\\n    content = document.documentElement.outerHTML;\\n  }\\n\\n  //Check DOM.\\n\\tif($(document).find(\\\"input#screen\\\").length === 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"Could not find <input> with id 'screen'.\\\");\\n\\t}\\n\\tif($(document).find(\\\"button#add\\\").length === 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"Could not find <button> with id 'add'.\\\");\\n\\t}\\n\\tif($(document).find(\\\"button#equals\\\").length === 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"Could not find <button> with id 'equals'.\\\");\\n\\t}\\n\\n  var screen = $(document).find(\\\"input#screen\\\");\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(5);\\n  $(document).find(\\\"#add\\\").trigger(\\\"click\\\");\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(2);\\n  $(document).find(\\\"#equals\\\").trigger(\\\"click\\\");\\n\\n  if(parseFloat($(screen).val()) != 7){\\n    return returnWithError(document,content,grade,\\\"Add function does not work as expected. Check it.\\\");\\n  }\\n\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(3);\\n  $(document).find(\\\"#add\\\").trigger(\\\"click\\\");\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(7);\\n  $(document).find(\\\"#equals\\\").trigger(\\\"click\\\");\\n\\n  if(parseFloat($(screen).val()) != 10){\\n    return returnWithError(document,content,grade,\\\"Add function does not work as expected. Check it.\\\");\\n  }\\n\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(\\\"Gato\\\");\\n  $(document).find(\\\"#add\\\").trigger(\\\"click\\\");\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(\\\"Perro\\\");\\n  $(document).find(\\\"#equals\\\").trigger(\\\"click\\\");\\n\\n  if($(screen).val() != \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"Calculator should show \\\\\\\"Error\\\\\\\" when any of the arguments is a text instead of a number\\\");\\n  }\\n\\n  grade.score = 10;\\n  grade.successes.push(\\\"Right.\\\");\\n\\n  resetState(document,content);\\n  return grade;\\n};\\n\\nvar returnWithError = function(document,content,grade,msg){\\n  resetState(document,content);\\n  grade.errors.push(msg);\\n  return grade;\\n};\\n\\nvar resetState = function(document,content){\\n  if((typeof document != \\\"undefined\\\")&&(typeof document.documentElement != \\\"undefined\\\")&&(typeof content != \\\"undefined\\\")){\\n\\t  document.open();\\n\\t  document.writeln(content);\\n\\t  document.close();\\n  }\\n};\"},{\"type\":\"exercise\",\"title\":\"d) Multiply\",\"description\":\"Add a new button to the calculator with identifier \\\"multiplication\\\" and text \\\"x\\\" that performs multiplications with two arguments.\\n\\nKeep the functionality that when any of the arguments introduced are a text instead of a number, it shows in the screen the message <b>'Error'</b>.\",\"editorMode\":\"HTML\",\"content\":\"<!DOCTYPE html>\\n<html>\\n<head>\\n\\t<title>Calculator</title>\\n\\t<meta charset=\\\"utf-8\\\">\\n  <script libname=\\\"jquery\\\" src=\\\"https://code.jquery.com/jquery-1.11.2.min.js\\\"></script>\\n</head>\\n<body>\\n\\n\\t<div>\\n\\t\\tNumber: <input type=\\\"text\\\" id=\\\"screen\\\"/>\\n\\t\\t<button id=\\\"add\\\">+</button>\\n\\t\\t<button id=\\\"equals\\\">=</button>\\n\\t</div>\\n\\n\\t<script type=\\\"text/javascript\\\">\\n\\t\\tvar acc = 0;\\n\\t\\tvar op;\\n\\n\\t\\t$(document).ready(function(){\\n\\t\\t\\t$(\\\"#screen\\\").click(function(){\\n\\t\\t\\t\\t$(this).val(\\\"\\\");\\n\\t\\t\\t});\\n\\t\\t\\t$(\\\"#add\\\").click(function(){\\n\\t\\t\\t\\tacc = parseFloat($(\\\"#screen\\\").val());\\n\\t\\t\\t\\top = \\\"+\\\";\\n\\t\\t\\t});\\n\\t\\t\\t$(\\\"#equals\\\").click(function(){\\n\\t\\t\\t\\tvar n = parseFloat($(\\\"#screen\\\").val());\\n\\t\\t\\t\\tif(op === \\\"+\\\"){\\n\\t\\t\\t\\t\\tacc += n;\\n\\t\\t\\t\\t} else {\\n\\t\\t\\t\\t\\tacc = n;\\n\\t\\t\\t\\t}\\n\\t\\t\\t\\t$(\\\"#screen\\\").val(acc);\\n\\t\\t\\t\\tacc = 0;\\n\\t\\t\\t\\top = undefined;\\n\\t\\t\\t});\\n\\t\\t});\\n\\t</script>\\n</body>\\n</html>\",\"progress\":{\"score\":0,\"passed\":false},\"score_function\":\"var score = function(document){\\n  var grade = {};\\n  grade.score = 0;\\n  grade.successes = [];\\n  grade.errors = [];\\n  grade.feedback = [];\\n  \\n  //Content\\n  var content;\\n  if((typeof document != \\\"undefined\\\")&&(typeof document.documentElement != \\\"undefined\\\")){\\n    content = document.documentElement.outerHTML;\\n  }\\n  \\n  //Check DOM\\n\\tif($(document).find(\\\"input#screen\\\").length === 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"Could not find <input> with id 'screen'.\\\");\\n\\t}\\n\\tif($(document).find(\\\"button#add\\\").length === 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"Could not find <button> with id 'add'.\\\");\\n\\t}\\n\\tif($(document).find(\\\"button#equals\\\").length === 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"Could not find <button> with id 'equals'.\\\");\\n\\t}\\n\\tvar multiplication;\\n\\tif($(document).find(\\\"button#multiplication\\\").length === 0){\\n\\t  return returnWithError(document,content,grade,\\\"Could not find <button> with id 'multiplication'.\\\");\\n\\t} else {\\n\\t   multiplication = $(document).find(\\\"button#multiplication\\\");\\n\\t}\\n\\t\\n\\tif($(multiplication).html().toLowerCase().trim() != \\\"x\\\"){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"<button> with id 'multiplication' should have text \\\\\\\"x\\\\\\\".\\\");\\n\\t}\\n\\t\\n  var screen = $(document).find(\\\"input#screen\\\");\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(5);\\n  $(multiplication).trigger(\\\"click\\\");\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(2);\\n  $(document).find(\\\"#equals\\\").trigger(\\\"click\\\");\\n  \\n  if(parseFloat($(screen).val()) != 10){\\n    return returnWithError(document,content,grade,\\\"Multiplication function does not work as expected.\\\");\\n  }\\n  \\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(3);\\n  $(multiplication).trigger(\\\"click\\\");\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(7);\\n  $(document).find(\\\"#equals\\\").trigger(\\\"click\\\");\\n  \\n  if(parseFloat($(screen).val()) != 21){\\n    return returnWithError(document,content,grade,\\\"Multiplication function does not work as expected.\\\");\\n  }\\n  \\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(\\\"Gato\\\");\\n  $(multiplication).trigger(\\\"click\\\");\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(\\\"Perro\\\");\\n  $(document).find(\\\"#equals\\\").trigger(\\\"click\\\");\\n  \\n  if($(screen).val() != \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"Calculator should show the word \\\\\\\"Error\\\\\\\" when any of the arguments is a text instead of a number\\\");\\n  }\\n  \\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(\\\"Gato\\\");\\n  $(multiplication).trigger(\\\"click\\\");\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(\\\"2\\\");\\n  $(document).find(\\\"#equals\\\").trigger(\\\"click\\\");\\n  \\n  if($(screen).val() != \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"Calculator should show the word \\\\\\\"Error\\\\\\\" when any of the arguments is a text instead of a number\\\");\\n  }\\n  \\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(\\\"2\\\");\\n  $(multiplication).trigger(\\\"click\\\");\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(\\\"Perro\\\");\\n  $(document).find(\\\"#equals\\\").trigger(\\\"click\\\");\\n  \\n  if($(screen).val() != \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"Calculator should show the word \\\\\\\"Error\\\\\\\" when any of the arguments is a text instead of a number\\\");\\n  }\\n\\n  grade.score = 10;\\n  grade.successes.push(\\\"Right.\\\");\\n\\n  resetState(document,content);\\n  return grade;\\n};\\n\\nvar returnWithError = function(document,content,grade,msg){\\n  resetState(document,content);\\n  grade.errors.push(msg);\\n  return grade;\\n};\\n\\nvar resetState = function(document,content){\\n  if((typeof document != \\\"undefined\\\")&&(typeof document.documentElement != \\\"undefined\\\")&&(typeof content != \\\"undefined\\\")){\\n\\t  document.open();\\n\\t  document.writeln(content);\\n\\t  document.close();\\n  }\\n};\"},{\"type\":\"exercise\",\"title\":\"e) Function f(b,x)\",\"description\":\"Add a new button to the calculator with an \\\"fbx\\\" identifier and text \\\"f(b,x)\\\" that implements the following mathematical operation: <code> f(b,x) = logb(x) = log10(x)/log10(b) </code>. \\nWhere <code>logb(x)</code> is the logarithm in base <b>b</b> of <b>x</b>, and the variables b and x are, respectively, the first and second operand entered in the calculator.\\nThe function must display the \\\"Error\\\" message on the screen if <b>b is not a natural number greater than 1</b> or if <b>x is not a real positive number</b>.\\nThus, when performing the following interaction (2)[f(b,x)](8) the final result displayed on the screen should be 3.\\n<i>NOTE: You can use the JavaScript <code>Math.log10</code> function to calculate logarithms on the basis of 10. </i>.\",\"editorMode\":\"HTML\",\"content\":\"<!DOCTYPE html>\\n<html>\\n<head>\\n\\t<title>Calculator</title>\\n\\t<meta charset=\\\"utf-8\\\">\\n  <script libname=\\\"jquery\\\" src=\\\"https://code.jquery.com/jquery-1.11.2.min.js\\\"></script>\\n</head>\\n<body>\\n\\n\\t<div>\\n\\t\\tNumber: <input type=\\\"text\\\" id=\\\"screen\\\"/>\\n\\t\\t<button id=\\\"add\\\">+</button>\\n\\t\\t<button id=\\\"equals\\\">=</button>\\n\\t</div>\\n\\n\\t<script type=\\\"text/javascript\\\">\\n\\t\\tvar acc = 0;\\n\\t\\tvar op;\\n\\n\\t\\t$(document).ready(function(){\\n\\t\\t\\t$(\\\"#screen\\\").click(function(){\\n\\t\\t\\t\\t$(this).val(\\\"\\\");\\n\\t\\t\\t});\\n\\t\\t\\t$(\\\"#add\\\").click(function(){\\n\\t\\t\\t\\tacc = parseFloat($(\\\"#screen\\\").val());\\n\\t\\t\\t\\top = \\\"+\\\";\\n\\t\\t\\t});\\n\\t\\t\\t$(\\\"#equals\\\").click(function(){\\n\\t\\t\\t\\tvar n = parseFloat($(\\\"#screen\\\").val());\\n\\t\\t\\t\\tif(op === \\\"+\\\"){\\n\\t\\t\\t\\t\\tacc += n;\\n\\t\\t\\t\\t} else {\\n\\t\\t\\t\\t\\tacc = n;\\n\\t\\t\\t\\t}\\n\\t\\t\\t\\t$(\\\"#screen\\\").val(acc);\\n\\t\\t\\t\\tacc = 0;\\n\\t\\t\\t\\top = undefined;\\n\\t\\t\\t});\\n\\t\\t});\\n\\t</script>\\n</body>\\n</html>\",\"progress\":{\"score\":0,\"passed\":false},\"score_function\":\"var score = function(document){\\n  var grade = {};\\n  grade.score = 0;\\n  grade.successes = [];\\n  grade.errors = [];\\n  grade.feedback = [];\\n\\n  //Content\\n  var content;\\n  if((typeof document != \\\"undefined\\\")&&(typeof document.documentElement != \\\"undefined\\\")){\\n    content = document.documentElement.outerHTML;\\n  }\\n\\n  //Existencia de elementos del DOM.\\n\\tif($(document).find(\\\"input#screen\\\").length === 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"<input> with id 'screen' could not be found.\\\");\\n\\t}\\n\\tif($(document).find(\\\"button#add\\\").length === 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"<input> with id 'add' could not be found.\\\");\\n\\t}\\n\\tif($(document).find(\\\"button#equals\\\").length === 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"<input> with id 'equals' could not be found.\\\");\\n\\t}\\n\\tif($(document).find(\\\"button#fbx\\\").length === 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"<input> with id 'fbx' could not be found.\\\");\\n\\t}\\n\\n\\tif($(document).find(\\\"button#fbx\\\").html().toLowerCase().trim() != \\\"f(b,x)\\\"){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"<button> with id 'multiplication' should have text \\\\\\\"f(b,x)\\\\\\\".\\\");\\n\\t}\\n\\n  var screen = $(document).find(\\\"input#screen\\\");\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(2);\\n  $(document).find(\\\"button#fbx\\\").trigger(\\\"click\\\");\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(8);\\n  $(document).find(\\\"#equals\\\").trigger(\\\"click\\\");\\n\\n  if(Math.abs(3-parseFloat($(screen).val())) > 0.1){\\n    return returnWithError(document,content,grade,\\\"Function f(b,x) does not work as expected.\\\");\\n  }\\n\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(5);\\n  $(document).find(\\\"button#fbx\\\").trigger(\\\"click\\\");\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(625);\\n  $(document).find(\\\"#equals\\\").trigger(\\\"click\\\");\\n\\n  if(Math.abs(4-parseFloat($(screen).val())) > 0.1){\\n    return returnWithError(document,content,grade,\\\"Function f(b,x) does not work as expected.\\\");\\n  }\\n\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(\\\"Gato\\\");\\n  $(document).find(\\\"button#fbx\\\").trigger(\\\"click\\\");\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(\\\"2\\\");\\n  $(document).find(\\\"#equals\\\").trigger(\\\"click\\\");\\n\\n  if($(screen).val() != \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"Calculator should show \\\\\\\"Error\\\\\\\" when any of the arguments is a string instead of a number.\\\");\\n  }\\n\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(\\\"2\\\");\\n  $(document).find(\\\"button#fbx\\\").trigger(\\\"click\\\");\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(\\\"Perro\\\");\\n  $(document).find(\\\"#equals\\\").trigger(\\\"click\\\");\\n\\n  if($(screen).val() != \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"Calculator should show \\\\\\\"Error\\\\\\\" when any of the arguments is a string instead of a number.\\\");\\n  }\\n\\n  //B natural negativo\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(\\\"-2\\\");\\n  $(document).find(\\\"button#fbx\\\").trigger(\\\"click\\\");\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(\\\"125\\\");\\n  $(document).find(\\\"#equals\\\").trigger(\\\"click\\\");\\n\\n  if($(screen).val() != \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"Calculator should show \\\\\\\"Error\\\\\\\" when argument b is negative\\\");\\n  }\\n\\n  //B=1\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(\\\"1\\\");\\n  $(document).find(\\\"button#fbx\\\").trigger(\\\"click\\\");\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(\\\"125\\\");\\n  $(document).find(\\\"#equals\\\").trigger(\\\"click\\\");\\n\\n  if($(screen).val() != \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"Calculator should show \\\\\\\"Error\\\\\\\" when argument b is below 1\\\");\\n  }\\n\\n  //B decimal\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(\\\"2.5\\\");\\n  $(document).find(\\\"button#fbx\\\").trigger(\\\"click\\\");\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(\\\"125\\\");\\n  $(document).find(\\\"#equals\\\").trigger(\\\"click\\\");\\n\\n  if($(screen).val() != \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"Calculator should show \\\\\\\"Error\\\\\\\" when argument b is not natural\\\");\\n  }\\n\\n  //X negativo\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(\\\"3\\\");\\n  $(document).find(\\\"button#fbx\\\").trigger(\\\"click\\\");\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(\\\"-125\\\");\\n  $(document).find(\\\"#equals\\\").trigger(\\\"click\\\");\\n\\n  if($(screen).val() != \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"Calculator should show \\\\\\\"Error\\\\\\\" when argument 'x' is not a positive real number\\\");\\n  }\\n\\n  //X decimal positivo\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(\\\"3\\\");\\n  $(document).find(\\\"button#fbx\\\").trigger(\\\"click\\\");\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(\\\"125.5\\\");\\n  $(document).find(\\\"#equals\\\").trigger(\\\"click\\\");\\n\\n  if($(screen).val() == \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"Calculator should not show \\\\\\\"Error\\\\\\\" when argument 'x' is a positive real number.\\\");\\n  }\\n\\n  //X=0\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(\\\"3\\\");\\n  $(document).find(\\\"button#fbx\\\").trigger(\\\"click\\\");\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(\\\"0\\\");\\n  $(document).find(\\\"#equals\\\").trigger(\\\"click\\\");\\n\\n  if($(screen).val() != \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"Calculator should show \\\\\\\"Error\\\\\\\" when argument 'x' is 0\\\");\\n  }\\n\\n  grade.score = 10;\\n  grade.successes.push(\\\"Right.\\\");\\n\\n  resetState(document,content);\\n  return grade;\\n};\\n\\nvar returnWithError = function(document,content,grade,msg){\\n  resetState(document,content);\\n  grade.errors.push(msg);\\n  return grade;\\n};\\n\\nvar resetState = function(document,content){\\n  if((typeof document != \\\"undefined\\\")&&(typeof document.documentElement != \\\"undefined\\\")&&(typeof content != \\\"undefined\\\")){\\n\\t  document.open();\\n\\t  document.writeln(content);\\n\\t  document.close();\\n  }\\n};\"},{\"type\":\"exercise\",\"title\":\"f) Error counter\",\"description\":\"This section shows a modification of the calculator that displays the message <b>\\\"Error\\\"</b> when one of the operands entered is a text string instead of a number. Make the following changes:\\n1) Add a <i><div></i> with a \\\"counter\\\" identifier that shows the number of errors in the calculator. The counter will start with the value 0 and increase by 1 each time an error is displayed on the calculator display.\\n2) Make use of the <i>error</i> class defined in the <code><style></code> tag so that the \\\"Error\\\" messages are shown in red on the calculator screen, but the rest of the values are shown with the usual color.\",\"editorMode\":\"HTML\",\"content\":\"<!DOCTYPE html>\\n<html>\\n<head>\\n\\t<title>Calculator</title>\\n\\t<meta charset=\\\"utf-8\\\">\\n  <script libname=\\\"jquery\\\" src=\\\"https://code.jquery.com/jquery-1.11.2.min.js\\\"></script>\\n  <style type=\\\"text/css\\\">\\n\\t  .error {\\n\\t    color: red;\\n\\t  }\\n\\t</style>\\n</head>\\n<body>\\n\\n\\t<div>\\n\\t\\tNumber: <input type=\\\"text\\\" id=\\\"screen\\\"/>\\n\\t\\t<button id=\\\"add\\\">+</button>\\n\\t\\t<button id=\\\"equals\\\">=</button>\\n\\t</div>\\n\\n\\t<script type=\\\"text/javascript\\\">\\n\\t\\tvar acc = 0;\\n\\t\\tvar op;\\n\\n\\t\\t$(document).ready(function(){\\n\\t\\t\\t$(\\\"#screen\\\").click(function(){\\n\\t\\t\\t\\t$(this).val(\\\"\\\");\\n\\t\\t\\t});\\n\\t\\t\\t$(\\\"#add\\\").click(function(){\\n\\t\\t\\t\\tacc = parseFloat($(\\\"#screen\\\").val());\\n\\t\\t\\t\\top = \\\"+\\\";\\n\\t\\t\\t});\\n\\t\\t\\t$(\\\"#equals\\\").click(function(){\\n\\t\\t\\t\\tvar n = parseFloat($(\\\"#screen\\\").val());\\n\\t\\t\\t\\tif(op === \\\"+\\\"){\\n\\t\\t\\t\\t\\tacc += n;\\n\\t\\t\\t\\t} else {\\n\\t\\t\\t\\t\\tacc = n;\\n\\t\\t\\t\\t}\\n\\t\\t\\t\\tif((typeof acc != \\\"number\\\")||(isNaN(acc))){\\n\\t\\t\\t\\t\\tacc = \\\"Error\\\";\\n\\t\\t\\t\\t}\\n\\t\\t\\t\\t$(\\\"#screen\\\").val(acc);\\n\\t\\t\\t\\tacc = 0;\\n\\t\\t\\t\\top = undefined;\\n\\t\\t\\t});\\n\\t\\t});\\n\\t</script>\\n</body>\\n</html>\",\"progress\":{\"score\":0,\"passed\":false},\"score_function\":\"var score = function(document){\\n  var grade = {};\\n  grade.score = 0;\\n  grade.successes = [];\\n  grade.errors = [];\\n  grade.feedback = [];\\n  \\n  //Content\\n  var content;\\n  if((typeof document != \\\"undefined\\\")&&(typeof document.documentElement != \\\"undefined\\\")){\\n    content = document.documentElement.outerHTML;\\n  }\\n  \\n  //Existencia de elementos del DOM.\\n  //Existencia de elementos del DOM.\\n\\tif($(document).find(\\\"input#screen\\\").length === 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"<input> with id 'screen' could not be found.\\\");\\n\\t}\\n\\tif($(document).find(\\\"button#add\\\").length === 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"<input> with id 'add' could not be found.\\\");\\n\\t}\\n\\tif($(document).find(\\\"button#equals\\\").length === 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"<input> with id 'equals' could not be found.\\\");\\n\\t}\\n\\t\\n\\tif($(document).find(\\\"div#counter\\\").length === 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"<div> with id 'counter' could not be found.\\\");\\n\\t}\\n\\tif(parseInt($(document).find(\\\"div#counter\\\").html()) !== 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"Counter should have a initial value of 0.\\\");\\n\\t}\\n\\t\\n  var screen = $(document).find(\\\"input#screen\\\");\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(5);\\n  $(document).find(\\\"#add\\\").trigger(\\\"click\\\");\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(2);\\n  $(document).find(\\\"#equals\\\").trigger(\\\"click\\\");\\n  \\n  if(parseFloat($(screen).val()) != 7){\\n    return returnWithError(document,content,grade,\\\"Add funtion does not work as expected.\\\");\\n  }\\n  \\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(3);\\n  $(document).find(\\\"#add\\\").trigger(\\\"click\\\");\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(7);\\n  $(document).find(\\\"#equals\\\").trigger(\\\"click\\\");\\n  \\n  if(parseFloat($(screen).val()) != 10){\\n    return returnWithError(document,content,grade,\\\"Add funtion does not work as expected.\\\");\\n  }\\n  \\n  //Trigger error\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(\\\"Gato\\\");\\n  $(document).find(\\\"#add\\\").trigger(\\\"click\\\");\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(\\\"Perro\\\");\\n  $(document).find(\\\"#equals\\\").trigger(\\\"click\\\");\\n  \\n  if($(screen).val() != \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"Calculator should show \\\\\\\"Error\\\\\\\" when any of the arguments is a string instead of a number.\\\");\\n  }\\n  \\n  if(parseInt($(document).find(\\\"div#counter\\\").html()) != 1){\\n\\t  return returnWithError(document,content,grade,\\\"Counter should have a  value of 1 after the first Error.\\\");\\n\\t}\\n\\t\\n\\tvar errorsToTrigger = 5;\\n\\tfor(var i=0; i<errorsToTrigger; i++){\\n  \\t//Trigger error\\n    $(screen).trigger(\\\"click\\\");\\n    $(screen).val(\\\"Gato\\\");\\n    $(document).find(\\\"#add\\\").trigger(\\\"click\\\");\\n    $(screen).trigger(\\\"click\\\");\\n    $(screen).val(\\\"Perro\\\");\\n    $(document).find(\\\"#equals\\\").trigger(\\\"click\\\"); \\n\\t}\\n\\n  if($(screen).val() != \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"Calculator should show \\\\\\\"Error\\\\\\\" when any of the arguments is a string instead of a number.\\\");\\n  }\\n  \\n  if(parseInt($(document).find(\\\"div#counter\\\").html()) != (errorsToTrigger+1)){\\n\\t  return returnWithError(document,content,grade,\\\"Counter does not count Errors.\\\");\\n\\t}\\n\\t\\n\\tif(!$(screen).hasClass(\\\"error\\\")){\\n    return returnWithError(document,content,grade,\\\"Screen should have class 'error' and show the text \\\\\\\"Error\\\\\\\".\\\");\\n  }\\n  \\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(3);\\n  if($(screen).hasClass(\\\"error\\\")){\\n    return returnWithError(document,content,grade,\\\"Screen should only have class 'error' when showing the \\\\\\\"Error\\\\\\\" in each moment.\\\");\\n  }\\n  $(document).find(\\\"#add\\\").trigger(\\\"click\\\");\\n  $(screen).trigger(\\\"click\\\");\\n  $(screen).val(7);\\n  $(document).find(\\\"#equals\\\").trigger(\\\"click\\\");\\n  \\n  if(parseFloat($(screen).val()) != 10){\\n    return returnWithError(document,content,grade,\\\"Add function does not work after an error\\\");\\n  }\\n  \\n  if($(screen).hasClass(\\\"error\\\")){\\n    return returnWithError(document,content,grade,\\\"Screen should only have class 'error' when showing the \\\\\\\"Error\\\\\\\" in each moment.\\\");\\n  }\\n\\n  grade.score = 10;\\n  grade.successes.push(\\\"Correcto.\\\");\\n\\n  resetState(document,content);\\n  return grade;\\n};\\n\\nvar returnWithError = function(document,content,grade,msg){\\n  resetState(document,content);\\n  grade.errors.push(msg);\\n  return grade;\\n};\\n\\nvar resetState = function(document,content){\\n  if((typeof document != \\\"undefined\\\")&&(typeof document.documentElement != \\\"undefined\\\")&&(typeof content != \\\"undefined\\\")){\\n\\t  document.open();\\n\\t  document.writeln(content);\\n\\t  document.close();\\n  }\\n};\\n\\n\"}]","exercisesQuantity":7,"parsed_exercises":[{"type":"exercise","title":"Introduction","description":"This is a very simple calculator that can only do additions with 2 arguments.\nPressing the button <b>Run code</b> (play) you can see the HTML page.\nPressing the title <b>Calculator</b> or the selector you can access the different exercises of this self-graded exercise.\nPress the button <b>Run Code</b>, test the calculator and go to the next step.","editorMode":"HTML","content":"<!DOCTYPE html>\n<html>\n<head>\n\t<title>Calculator</title>\n\t<meta charset=\"utf-8\">\n  <script libname=\"jquery\" src=\"https://code.jquery.com/jquery-1.11.2.min.js\"></script>\n</head>\n<body>\n\n\t<div>\n\t\tNumber: <input type=\"text\" id=\"screen\"/>\n\t\t<button id=\"add\">+</button>\n\t\t<button id=\"equals\">=</button>\n\t</div>\n\n\t<script type=\"text/javascript\">\n\t\tvar acc = 0;\n\t\tvar op;\n\n\t\t$(document).ready(function(){ \n\t\t\t$(\"#screen\").click(function(){\n\t\t\t\t$(this).val(\"\");\n\t\t\t});\n\t\t\t$(\"#add\").click(function(){\n\t\t\t\tacc = parseFloat($(\"#screen\").val());\n\t\t\t\top = \"+\";\n\t\t\t});\n\t\t\t$(\"#equals\").click(function(){\n\t\t\t\tvar n = parseFloat($(\"#screen\").val());\n\t\t\t\tif(op === \"+\"){\n\t\t\t\t\tacc += n;\n\t\t\t\t} else {\n\t\t\t\t\tacc = n;\n\t\t\t\t}\n\t\t\t\t$(\"#screen\").val(acc);\n\t\t\t\tacc = 0;\n\t\t\t\top = undefined;\n\t\t\t});\n\t\t});\n\t</script>\n</body>\n</html>","progress":{"score":0,"passed":false},"id":1},{"type":"exercise","title":"a) HTML tags","description":"Add a header to the HTML document (with the <code><header></code> tag) with identifier \"myheader\", class \"big\", an attribute \"title\" with value \"Main header\" and content \"Welcome to my calculator\"","editorMode":"HTML","content":"<!DOCTYPE html>\n<html>\n<head>\n\t<title>Calculator</title>\n\t<meta charset=\"utf-8\">\n  <script libname=\"jquery\" src=\"https://code.jquery.com/jquery-1.11.2.min.js\"></script>\n</head>\n<body>\n\n\t<div>\n\t\tNumber: <input type=\"text\" id=\"screen\"/>\n\t\t<button id=\"add\">+</button>\n\t\t<button id=\"equals\">=</button>\n\t</div>\n\n\t<script type=\"text/javascript\">\n\t\tvar acc = 0;\n\t\tvar op;\n\n\t\t$(document).ready(function(){ \n\t\t\t$(\"#screen\").click(function(){\n\t\t\t\t$(this).val(\"\");\n\t\t\t});\n\t\t\t$(\"#add\").click(function(){\n\t\t\t\tacc = parseFloat($(\"#screen\").val());\n\t\t\t\top = \"+\";\n\t\t\t});\n\t\t\t$(\"#equals\").click(function(){\n\t\t\t\tvar n = parseFloat($(\"#screen\").val());\n\t\t\t\tif(op === \"+\"){\n\t\t\t\t\tacc += n;\n\t\t\t\t} else {\n\t\t\t\t\tacc = n;\n\t\t\t\t}\n\t\t\t\t$(\"#screen\").val(acc);\n\t\t\t\tacc = 0;\n\t\t\t\top = undefined;\n\t\t\t});\n\t\t});\n\t</script>\n</body>\n</html>","progress":{"score":0,"passed":false},"score_function":"var score = function(document){\n  var grade = {};\n  grade.successes = [];\n  grade.errors = [];\n  grade.feedback = [];\n  grade.score = 0;\n  \n  //Is there a <header>.\n\tif($(document).find(\"header\").length === 0){\n\t  \tgrade.errors.push(\"There is no <header> tag.\");\n\t  \treturn grade;\n\t}\n\tif($(document).find(\"body header\").length === 0){\n\t  \tgrade.errors.push(\"<header> should be inside <body>.\");\n\t  \treturn grade;\n\t}\n\tif($(document).find(\"body header#myheader\").length === 0){\n\t  \tgrade.errors.push(\"<header> should have identifier 'myheader'.\");\n\t  \treturn grade;\n\t}\n\tif($(document).find(\"body header#myheader.big\").length === 0){\n\t  \tgrade.errors.push(\"<header> should have class 'big'.\");\n\t  \treturn grade;\n\t}\n\tif($(document).find(\"body header#myheader.big[title]\").length === 0){\n\t  \tgrade.errors.push(\"<header> should have attribute 'title'.\");\n\t  \treturn grade;\n\t}\n\tif($(document).find(\"body header#myheader.big[title='Main header']\").length === 0){\n\t  \tgrade.errors.push(\"<header> should have a 'title' attribute with value 'Main header'.\");\n\t  \treturn grade;\n\t}\n\tvar header = $(document).find(\"body header#myheader.big[title='Main header']\");\n\tvar headerContent = $(header).html();\n\t\n\tif(headerContent.replace(/ +/g,\"\").toLowerCase().indexOf(\"welcometomycalculator\")==-1){\n\t  grade.errors.push(\"The content of the <header> should be 'Welcome to my calculator'.\");\n\t  return grade;\n\t}\n\t\n  grade.score = 10;\n  grade.successes.push(\"Perfect.\");\n\n  return grade;\n};","id":2},{"type":"exercise","title":"b)  CSS styles","description":"Complete and modify the content of the <code><style type=\"text/css\"></code> tag<b> without modifying the DOM tree of the page</b> so that:\n* The screen of the calculator has a black background but the numbers are shown in white.\n* All buttons inside <code><div class=\"calculator keyboard\"></code> have black background and white font.\n* All buttons inside <code><div class=\"calculator keyboard\"></code> with an attribute \"operation\" equals to \"true\" have a blue border.\n* All inputs of type text (including the screen) have a red border when their containing <div> has class \"error\"","editorMode":"HTML","content":"<!DOCTYPE html>\n<html>\n<head>\n\t<title>Calculator</title>\n\t<meta charset=\"utf-8\">\n  <script libname=\"jquery\" src=\"https://code.jquery.com/jquery-1.11.2.min.js\"></script>\n  <style type=\"text/css\">\n\t  /* Write your solution here */\n\t  #screen {\n\t    background: white;\n\t  }\n\t</style>\n</head>\n<body>\n\n\t<div class=\"calculator keyboard\">\n\t\tNumber: <input type=\"text\" id=\"screen\"/>\n\t\t<button id=\"add\" operation=\"true\">+</button>\n\t\t<button id=\"equals\">=</button>\n\t</div>\n\n\t<script type=\"text/javascript\">\n\t\tvar acc = 0;\n\t\tvar op;\n\n\t\t$(document).ready(function(){ \n\t\t\t$(\"#screen\").click(function(){\n\t\t\t\t$(this).val(\"\");\n\t\t\t});\n\t\t\t$(\"#add\").click(function(){\n\t\t\t\tacc = parseFloat($(\"#screen\").val());\n\t\t\t\top = \"+\";\n\t\t\t});\n\t\t\t$(\"#equals\").click(function(){\n\t\t\t\tvar n = parseFloat($(\"#screen\").val());\n\t\t\t\tif(op === \"+\"){\n\t\t\t\t\tacc += n;\n\t\t\t\t} else {\n\t\t\t\t\tacc = n;\n\t\t\t\t}\n\t\t\t\t$(\"#screen\").val(acc);\n\t\t\t\tacc = 0;\n\t\t\t\top = undefined;\n\t\t\t});\n\t\t});\n\t</script>\n</body>\n</html>","progress":{"score":0,"passed":false},"score_function":"var score = function(document){\n  var grade = {};\n  grade.successes = [];\n  grade.errors = [];\n  grade.feedback = [];\n  grade.score = 0;\n  \n  //Replace content\n  if((typeof document != \"undefined\")&&(typeof document.documentElement != \"undefined\")){\n    var bodyContent = '<div class=\"calculator keyboard\"> Number: <input type=\"text\" id=\"screen\"> <button id=\"add\" operation=\"true\">+</button> <button id=\"equals\">=</button> <input id=\"test6\" operation=\"true\" style=\"display:none\"> </div> <div id=\"test1\" class=\"calculator\" style=\"display:none\"> <input> <button>b</button> <button operation=\"true\">op</button> </div> <div id=\"test2\" class=\"keyboard\" style=\"display:none\"> <input> <button>b</button> <button operation=\"true\">op</button> </div> <article id=\"test3\" class=\"calculator keyboard\" style=\"display:none\"> <input> <button>b</button> <button operation=\"true\">op</button> </article> <div id=\"test4\" class=\"error\" style=\"display:none\"> <input type=\"text\"> <input type=\"number\"> <div type=\"text\"></div> </div> <article id=\"test5\" class=\"error\" style=\"display:none\"> <input type=\"text\"> <input type=\"number\"> <div type=\"text\"></div> </article> <script type=\"text/javascript\"> var acc = 0; var op; $(document).ready(function(){ $(\"#screen\").click(function(){ $(this).val(\"\"); }); $(\"#add\").click(function(){ acc = parseFloat($(\"#screen\").val()); op = \"+\"; }); $(\"#equals\").click(function(){ var n = parseFloat($(\"#screen\").val()); if(op === \"+\"){ acc += n; } else { acc = n; } $(\"#screen\").val(acc); acc = 0; op = undefined; }); }); </script>';\n    $(document).find(\"body\").html(bodyContent);\n    \n    //Restore events\n    $(document).find(\"#screen\").click(function(){\n\t\t\t$(this).val(\"\");\n\t\t});\n\t\t$(document).find(\"#add\").click(function(){\n\t\t\tacc = parseFloat($(document).find(\"#screen\").val());\n\t\t\top = \"+\";\n\t\t});\n\t\t$(document).find(\"#equals\").click(function(){\n\t\t\tvar n = parseFloat($(document).find(\"#screen\").val());\n\t\t\tif(op === \"+\"){\n\t\t\t\tacc += n;\n\t\t\t} else {\n\t\t\t\tacc = n;\n\t\t\t}\n\t\t\t$(document).find(\"#screen\").val(acc);\n\t\t\tacc = 0;\n\t\t\top = undefined;\n\t\t});\n  }\n  \n  //Tests\n\tif($(document).find(\"#screen\").css(\"background-color\") != \"rgb(0, 0, 0)\"){\n\t  \tgrade.errors.push(\"Calculator screen should have background black.\");\n\t  \treturn grade;\n\t}\n\tif($(document).find(\"#screen\").css(\"color\") != \"rgb(255, 255, 255)\"){\n\t  \tgrade.errors.push(\"screen should show text in white color.\");\n\t  \treturn grade;\n\t}\n\t\n\tif($(document).find(\"input\").not(\"#screen\").css(\"background-color\") == \"rgb(0, 0, 0)\"){\n\t  \tgrade.errors.push(\"Only screen <input> should be black.\");\n\t  \treturn grade;\n\t}\n\t\n\tif($(document).find(\"input\").not(\"#screen\").css(\"color\") == \"rgb(255, 255, 255)\"){\n\t  grade.errors.push(\"Only screen <input> should have white text.\");\n\t  return grade;\n\t}\n\t\n\tif($(document).find(\"div.calculator.keyboard button\").css(\"background-color\") != \"rgb(0, 0, 0)\"){\n\t  \tgrade.errors.push(\"All buttons inside <div class=\\\"calculator keyboard\\\">  should have black background.\");\n\t  \treturn grade;\n\t}\n\t\n\tif($(document).find(\"div.calculator.keyboard button\").css(\"color\") != \"rgb(255, 255, 255)\"){\n\t  \tgrade.errors.push(\"All buttons inside <div class=\\\"calculator keyboard\\\"> should have white font.\");\n\t  \treturn grade;\n\t}\n\tif($(document).find(\"div.calculator.keyboard button[operation='true']\").css(\"border-top-color\") != \"rgb(0, 0, 255)\"){\n\t  \tgrade.errors.push(\"All buttons inside <div class=\\\"calculator keyboard\\\"> with attribute \\\"operation\\\" equals \\\"true\\\" should have blue border.\");\n\t  \treturn grade;\n\t}\n\t\n\t//Check CSS double class selector\n\tif($(document).find(\"div#test2.keyboard button\").css(\"background-color\") == \"rgb(0, 0, 0)\"){\n\t  \tgrade.errors.push(\"The CSS selector to apply the style to all buttons inside <div class=\\\"calculator keyboard\\\"> is not right.\");\n\t  \treturn grade;\n\t}\n\tif($(document).find(\"div#test2.keyboard button\").css(\"color\") == \"rgb(255, 255, 255)\"){\n\t  \tgrade.errors.push(\"The CSS selector to apply the style to all buttons inside <div class=\\\"calculator keyboard\\\"> is not right.\");\n\t  \treturn grade;\n\t}\n\tif($(document).find(\"div#test2.keyboard button[operation='true']\").css(\"border-top-color\") == \"rgb(0, 0, 255)\"){\n      grade.errors.push(\"The CSS selector to apply the style to all buttons inside <div class=\\\"calculator keyboard\\\">  with attribute 'operation' is not right.\");\n\t  \treturn grade;\n\t}\n\t\n\tif($(document).find(\"div#test1.calculator button\").css(\"background-color\") == \"rgb(0, 0, 0)\"){\n      grade.errors.push(\"The CSS selector to apply the style to all buttons inside <div class=\\\"calculator keyboard\\\"> is not right.\");\n\t  \treturn grade;\n\t}\n\tif($(document).find(\"div#test1.calculator button\").css(\"color\") == \"rgb(255, 255, 255)\"){\n      grade.errors.push(\"The CSS selector to apply the style to all buttons inside <div class=\\\"calculator keyboard\\\"> is not right.\");\n\t  \treturn grade;\n\t}\n\tif($(document).find(\"div#test1.calculator button[operation='true']\").css(\"border-top-color\") == \"rgb(0, 0, 255)\"){\n      grade.errors.push(\"The CSS selector to apply the style to all buttons inside <div class=\\\"calculator keyboard\\\"> is not right.\");\n\t  \treturn grade;\n\t}\n\t\n\tif($(document).find(\"article#test3.calculator.keyboard button\").css(\"background-color\") == \"rgb(0, 0, 0)\"){\n      grade.errors.push(\"The CSS selector to apply the style to all buttons inside <div class=\\\"calculator keyboard\\\"> is not right.\");\n\t  \treturn grade;\n\t}\n\tif($(document).find(\"article#test3.calculator.keyboard button\").css(\"color\") == \"rgb(255, 255, 255)\"){\n      grade.errors.push(\"The CSS selector to apply the style to all buttons inside <div class=\\\"calculator keyboard\\\"> is not right.\");\n\t  \treturn grade;\n\t}\n\tif($(document).find(\"article#test3.calculator.keyboard button[operation='true']\").css(\"color\") == \"rgb(0, 0, 255)\"){\n    grade.errors.push(\"The CSS selector to apply the style to all buttons inside <div class=\\\"calculator keyboard\\\">  with attribute 'operation' is not right.\");\n\t  \treturn grade;\n\t}\n\t\n\tif($(document).find(\"div.calculator.keyboard button[operation!='true']\").css(\"border-top-color\") == \"rgb(0, 0, 255)\"){\n    grade.errors.push(\"The CSS selector to apply the style to all buttons inside <div class=\\\"calculator keyboard\\\">  with attribute 'operation' is not right.\");\n\t  \treturn grade;\n\t}\n\tif($(document).find(\"div.calculator.keyboard input#test6[operation='true']\").css(\"border-top-color\") == \"rgb(0, 0, 255)\"){\n      grade.feedback.push()\t     \n      grade.errors.push(\"The CSS selector to apply the style to all buttons inside <div class=\\\"calculator keyboard\\\">  with attribute 'operation' is not right.\");\n\t  \treturn grade;\n\t}\n\t\n\tif($(document).find(\"div input[type='text']\").css(\"border-top-color\") == \"rgb(255, 0, 0)\"){\n\t  \tgrade.errors.push(\"Inputs should only have a red border if their containing <div> has class \\\"error\\\".\");\n\t  \treturn grade;\n\t}\n\t\n\tif($(document).find(\"div#test4.error input[type='text']\").css(\"border-top-color\") != \"rgb(255, 0, 0)\"){\n    grade.errors.push(\"Inputs should only have a red border if their containing <div> has class \\\"error\\\".\");\n\t  \treturn grade;\n\t}\n\t\n\tif($(document).find(\"article#test5.error input[type='text']\").css(\"border-top-color\") == \"rgb(255, 0, 0)\"){\n    grade.errors.push(\"Inputs should only have a red border if their containing <div> has class \\\"error\\\".\");\n\t  \treturn grade;\n\t}\n\t\n\tif($(document).find(\"div#test4.error input[type!='text']\").css(\"border-top-color\") == \"rgb(255, 0, 0)\"){\n    grade.errors.push(\"Inputs should only have a red border if their are text type\");\n\t  \treturn grade;\n\t}\n\t\n\tif($(document).find(\"div#test4.error div[type='text']\").css(\"border-top-color\") == \"rgb(255, 0, 0)\"){\n    grade.errors.push(\"Only inputs and no other elements should only have a red border if their containing <div> has class \\\"error\\\".\");\n\t  \treturn grade;\n\t}\n\n  grade.score = 10;\n  grade.successes.push(\"Right.\");\n\n  return grade;\n};","id":3},{"type":"exercise","title":"c)  Error management","description":"Modify the calculator so that when any of the arguments introduced are a text instead of a number, it shows in the screen the message <b>'Error'</b>.","editorMode":"HTML","content":"<!DOCTYPE html>\n<html>\n<head>\n\t<title>Calculator</title>\n\t<meta charset=\"utf-8\">\n  <script libname=\"jquery\" src=\"https://code.jquery.com/jquery-1.11.2.min.js\"></script>\n</head>\n<body>\n\n\t<div>\n\t\tNumber: <input type=\"text\" id=\"screen\"/>\n\t\t<button id=\"add\">+</button>\n\t\t<button id=\"equals\">=</button>\n\t</div>\n\n\t<script type=\"text/javascript\">\n\t\tvar acc = 0;\n\t\tvar op;\n\n\t\t$(document).ready(function(){\n\t\t\t$(\"#screen\").click(function(){\n\t\t\t\t$(this).val(\"\");\n\t\t\t});\n\t\t\t$(\"#add\").click(function(){\n\t\t\t\tacc = parseFloat($(\"#screen\").val());\n\t\t\t\top = \"+\";\n\t\t\t});\n\t\t\t$(\"#equals\").click(function(){\n\t\t\t\tvar n = parseFloat($(\"#screen\").val());\n\t\t\t\tif(op === \"+\"){\n\t\t\t\t\tacc += n;\n\t\t\t\t} else {\n\t\t\t\t\tacc = n;\n\t\t\t\t}\n\t\t\t\t$(\"#screen\").val(acc);\n\t\t\t\tacc = 0;\n\t\t\t\top = undefined;\n\t\t\t});\n\t\t});\n\t</script>\n</body>\n</html>","progress":{"score":0,"passed":false},"score_function":"var score = function(document){\n  var grade = {};\n  grade.score = 0;\n  grade.successes = [];\n  grade.errors = [];\n  grade.feedback = [];\n\n  //Content\n  var content;\n  if((typeof document != \"undefined\")&&(typeof document.documentElement != \"undefined\")){\n    content = document.documentElement.outerHTML;\n  }\n\n  //Check DOM.\n\tif($(document).find(\"input#screen\").length === 0){\n\t  \treturn returnWithError(document,content,grade,\"Could not find <input> with id 'screen'.\");\n\t}\n\tif($(document).find(\"button#add\").length === 0){\n\t  \treturn returnWithError(document,content,grade,\"Could not find <button> with id 'add'.\");\n\t}\n\tif($(document).find(\"button#equals\").length === 0){\n\t  \treturn returnWithError(document,content,grade,\"Could not find <button> with id 'equals'.\");\n\t}\n\n  var screen = $(document).find(\"input#screen\");\n  $(screen).trigger(\"click\");\n  $(screen).val(5);\n  $(document).find(\"#add\").trigger(\"click\");\n  $(screen).trigger(\"click\");\n  $(screen).val(2);\n  $(document).find(\"#equals\").trigger(\"click\");\n\n  if(parseFloat($(screen).val()) != 7){\n    return returnWithError(document,content,grade,\"Add function does not work as expected. Check it.\");\n  }\n\n  $(screen).trigger(\"click\");\n  $(screen).val(3);\n  $(document).find(\"#add\").trigger(\"click\");\n  $(screen).trigger(\"click\");\n  $(screen).val(7);\n  $(document).find(\"#equals\").trigger(\"click\");\n\n  if(parseFloat($(screen).val()) != 10){\n    return returnWithError(document,content,grade,\"Add function does not work as expected. Check it.\");\n  }\n\n  $(screen).trigger(\"click\");\n  $(screen).val(\"Gato\");\n  $(document).find(\"#add\").trigger(\"click\");\n  $(screen).trigger(\"click\");\n  $(screen).val(\"Perro\");\n  $(document).find(\"#equals\").trigger(\"click\");\n\n  if($(screen).val() != \"Error\"){\n    return returnWithError(document,content,grade,\"Calculator should show \\\"Error\\\" when any of the arguments is a text instead of a number\");\n  }\n\n  grade.score = 10;\n  grade.successes.push(\"Right.\");\n\n  resetState(document,content);\n  return grade;\n};\n\nvar returnWithError = function(document,content,grade,msg){\n  resetState(document,content);\n  grade.errors.push(msg);\n  return grade;\n};\n\nvar resetState = function(document,content){\n  if((typeof document != \"undefined\")&&(typeof document.documentElement != \"undefined\")&&(typeof content != \"undefined\")){\n\t  document.open();\n\t  document.writeln(content);\n\t  document.close();\n  }\n};","id":4},{"type":"exercise","title":"d) Multiply","description":"Add a new button to the calculator with identifier \"multiplication\" and text \"x\" that performs multiplications with two arguments.\n\nKeep the functionality that when any of the arguments introduced are a text instead of a number, it shows in the screen the message <b>'Error'</b>.","editorMode":"HTML","content":"<!DOCTYPE html>\n<html>\n<head>\n\t<title>Calculator</title>\n\t<meta charset=\"utf-8\">\n  <script libname=\"jquery\" src=\"https://code.jquery.com/jquery-1.11.2.min.js\"></script>\n</head>\n<body>\n\n\t<div>\n\t\tNumber: <input type=\"text\" id=\"screen\"/>\n\t\t<button id=\"add\">+</button>\n\t\t<button id=\"equals\">=</button>\n\t</div>\n\n\t<script type=\"text/javascript\">\n\t\tvar acc = 0;\n\t\tvar op;\n\n\t\t$(document).ready(function(){\n\t\t\t$(\"#screen\").click(function(){\n\t\t\t\t$(this).val(\"\");\n\t\t\t});\n\t\t\t$(\"#add\").click(function(){\n\t\t\t\tacc = parseFloat($(\"#screen\").val());\n\t\t\t\top = \"+\";\n\t\t\t});\n\t\t\t$(\"#equals\").click(function(){\n\t\t\t\tvar n = parseFloat($(\"#screen\").val());\n\t\t\t\tif(op === \"+\"){\n\t\t\t\t\tacc += n;\n\t\t\t\t} else {\n\t\t\t\t\tacc = n;\n\t\t\t\t}\n\t\t\t\t$(\"#screen\").val(acc);\n\t\t\t\tacc = 0;\n\t\t\t\top = undefined;\n\t\t\t});\n\t\t});\n\t</script>\n</body>\n</html>","progress":{"score":0,"passed":false},"score_function":"var score = function(document){\n  var grade = {};\n  grade.score = 0;\n  grade.successes = [];\n  grade.errors = [];\n  grade.feedback = [];\n  \n  //Content\n  var content;\n  if((typeof document != \"undefined\")&&(typeof document.documentElement != \"undefined\")){\n    content = document.documentElement.outerHTML;\n  }\n  \n  //Check DOM\n\tif($(document).find(\"input#screen\").length === 0){\n\t  \treturn returnWithError(document,content,grade,\"Could not find <input> with id 'screen'.\");\n\t}\n\tif($(document).find(\"button#add\").length === 0){\n\t  \treturn returnWithError(document,content,grade,\"Could not find <button> with id 'add'.\");\n\t}\n\tif($(document).find(\"button#equals\").length === 0){\n\t  \treturn returnWithError(document,content,grade,\"Could not find <button> with id 'equals'.\");\n\t}\n\tvar multiplication;\n\tif($(document).find(\"button#multiplication\").length === 0){\n\t  return returnWithError(document,content,grade,\"Could not find <button> with id 'multiplication'.\");\n\t} else {\n\t   multiplication = $(document).find(\"button#multiplication\");\n\t}\n\t\n\tif($(multiplication).html().toLowerCase().trim() != \"x\"){\n\t  \treturn returnWithError(document,content,grade,\"<button> with id 'multiplication' should have text \\\"x\\\".\");\n\t}\n\t\n  var screen = $(document).find(\"input#screen\");\n  $(screen).trigger(\"click\");\n  $(screen).val(5);\n  $(multiplication).trigger(\"click\");\n  $(screen).trigger(\"click\");\n  $(screen).val(2);\n  $(document).find(\"#equals\").trigger(\"click\");\n  \n  if(parseFloat($(screen).val()) != 10){\n    return returnWithError(document,content,grade,\"Multiplication function does not work as expected.\");\n  }\n  \n  $(screen).trigger(\"click\");\n  $(screen).val(3);\n  $(multiplication).trigger(\"click\");\n  $(screen).trigger(\"click\");\n  $(screen).val(7);\n  $(document).find(\"#equals\").trigger(\"click\");\n  \n  if(parseFloat($(screen).val()) != 21){\n    return returnWithError(document,content,grade,\"Multiplication function does not work as expected.\");\n  }\n  \n  $(screen).trigger(\"click\");\n  $(screen).val(\"Gato\");\n  $(multiplication).trigger(\"click\");\n  $(screen).trigger(\"click\");\n  $(screen).val(\"Perro\");\n  $(document).find(\"#equals\").trigger(\"click\");\n  \n  if($(screen).val() != \"Error\"){\n    return returnWithError(document,content,grade,\"Calculator should show the word \\\"Error\\\" when any of the arguments is a text instead of a number\");\n  }\n  \n  $(screen).trigger(\"click\");\n  $(screen).val(\"Gato\");\n  $(multiplication).trigger(\"click\");\n  $(screen).trigger(\"click\");\n  $(screen).val(\"2\");\n  $(document).find(\"#equals\").trigger(\"click\");\n  \n  if($(screen).val() != \"Error\"){\n    return returnWithError(document,content,grade,\"Calculator should show the word \\\"Error\\\" when any of the arguments is a text instead of a number\");\n  }\n  \n  $(screen).trigger(\"click\");\n  $(screen).val(\"2\");\n  $(multiplication).trigger(\"click\");\n  $(screen).trigger(\"click\");\n  $(screen).val(\"Perro\");\n  $(document).find(\"#equals\").trigger(\"click\");\n  \n  if($(screen).val() != \"Error\"){\n    return returnWithError(document,content,grade,\"Calculator should show the word \\\"Error\\\" when any of the arguments is a text instead of a number\");\n  }\n\n  grade.score = 10;\n  grade.successes.push(\"Right.\");\n\n  resetState(document,content);\n  return grade;\n};\n\nvar returnWithError = function(document,content,grade,msg){\n  resetState(document,content);\n  grade.errors.push(msg);\n  return grade;\n};\n\nvar resetState = function(document,content){\n  if((typeof document != \"undefined\")&&(typeof document.documentElement != \"undefined\")&&(typeof content != \"undefined\")){\n\t  document.open();\n\t  document.writeln(content);\n\t  document.close();\n  }\n};","id":5},{"type":"exercise","title":"e) Function f(b,x)","description":"Add a new button to the calculator with an \"fbx\" identifier and text \"f(b,x)\" that implements the following mathematical operation: <code> f(b,x) = logb(x) = log10(x)/log10(b) </code>. \nWhere <code>logb(x)</code> is the logarithm in base <b>b</b> of <b>x</b>, and the variables b and x are, respectively, the first and second operand entered in the calculator.\nThe function must display the \"Error\" message on the screen if <b>b is not a natural number greater than 1</b> or if <b>x is not a real positive number</b>.\nThus, when performing the following interaction (2)[f(b,x)](8) the final result displayed on the screen should be 3.\n<i>NOTE: You can use the JavaScript <code>Math.log10</code> function to calculate logarithms on the basis of 10. </i>.","editorMode":"HTML","content":"<!DOCTYPE html>\n<html>\n<head>\n\t<title>Calculator</title>\n\t<meta charset=\"utf-8\">\n  <script libname=\"jquery\" src=\"https://code.jquery.com/jquery-1.11.2.min.js\"></script>\n</head>\n<body>\n\n\t<div>\n\t\tNumber: <input type=\"text\" id=\"screen\"/>\n\t\t<button id=\"add\">+</button>\n\t\t<button id=\"equals\">=</button>\n\t</div>\n\n\t<script type=\"text/javascript\">\n\t\tvar acc = 0;\n\t\tvar op;\n\n\t\t$(document).ready(function(){\n\t\t\t$(\"#screen\").click(function(){\n\t\t\t\t$(this).val(\"\");\n\t\t\t});\n\t\t\t$(\"#add\").click(function(){\n\t\t\t\tacc = parseFloat($(\"#screen\").val());\n\t\t\t\top = \"+\";\n\t\t\t});\n\t\t\t$(\"#equals\").click(function(){\n\t\t\t\tvar n = parseFloat($(\"#screen\").val());\n\t\t\t\tif(op === \"+\"){\n\t\t\t\t\tacc += n;\n\t\t\t\t} else {\n\t\t\t\t\tacc = n;\n\t\t\t\t}\n\t\t\t\t$(\"#screen\").val(acc);\n\t\t\t\tacc = 0;\n\t\t\t\top = undefined;\n\t\t\t});\n\t\t});\n\t</script>\n</body>\n</html>","progress":{"score":0,"passed":false},"score_function":"var score = function(document){\n  var grade = {};\n  grade.score = 0;\n  grade.successes = [];\n  grade.errors = [];\n  grade.feedback = [];\n\n  //Content\n  var content;\n  if((typeof document != \"undefined\")&&(typeof document.documentElement != \"undefined\")){\n    content = document.documentElement.outerHTML;\n  }\n\n  //Existencia de elementos del DOM.\n\tif($(document).find(\"input#screen\").length === 0){\n\t  \treturn returnWithError(document,content,grade,\"<input> with id 'screen' could not be found.\");\n\t}\n\tif($(document).find(\"button#add\").length === 0){\n\t  \treturn returnWithError(document,content,grade,\"<input> with id 'add' could not be found.\");\n\t}\n\tif($(document).find(\"button#equals\").length === 0){\n\t  \treturn returnWithError(document,content,grade,\"<input> with id 'equals' could not be found.\");\n\t}\n\tif($(document).find(\"button#fbx\").length === 0){\n\t  \treturn returnWithError(document,content,grade,\"<input> with id 'fbx' could not be found.\");\n\t}\n\n\tif($(document).find(\"button#fbx\").html().toLowerCase().trim() != \"f(b,x)\"){\n\t  \treturn returnWithError(document,content,grade,\"<button> with id 'multiplication' should have text \\\"f(b,x)\\\".\");\n\t}\n\n  var screen = $(document).find(\"input#screen\");\n  $(screen).trigger(\"click\");\n  $(screen).val(2);\n  $(document).find(\"button#fbx\").trigger(\"click\");\n  $(screen).trigger(\"click\");\n  $(screen).val(8);\n  $(document).find(\"#equals\").trigger(\"click\");\n\n  if(Math.abs(3-parseFloat($(screen).val())) > 0.1){\n    return returnWithError(document,content,grade,\"Function f(b,x) does not work as expected.\");\n  }\n\n  $(screen).trigger(\"click\");\n  $(screen).val(5);\n  $(document).find(\"button#fbx\").trigger(\"click\");\n  $(screen).trigger(\"click\");\n  $(screen).val(625);\n  $(document).find(\"#equals\").trigger(\"click\");\n\n  if(Math.abs(4-parseFloat($(screen).val())) > 0.1){\n    return returnWithError(document,content,grade,\"Function f(b,x) does not work as expected.\");\n  }\n\n  $(screen).trigger(\"click\");\n  $(screen).val(\"Gato\");\n  $(document).find(\"button#fbx\").trigger(\"click\");\n  $(screen).trigger(\"click\");\n  $(screen).val(\"2\");\n  $(document).find(\"#equals\").trigger(\"click\");\n\n  if($(screen).val() != \"Error\"){\n    return returnWithError(document,content,grade,\"Calculator should show \\\"Error\\\" when any of the arguments is a string instead of a number.\");\n  }\n\n  $(screen).trigger(\"click\");\n  $(screen).val(\"2\");\n  $(document).find(\"button#fbx\").trigger(\"click\");\n  $(screen).trigger(\"click\");\n  $(screen).val(\"Perro\");\n  $(document).find(\"#equals\").trigger(\"click\");\n\n  if($(screen).val() != \"Error\"){\n    return returnWithError(document,content,grade,\"Calculator should show \\\"Error\\\" when any of the arguments is a string instead of a number.\");\n  }\n\n  //B natural negativo\n  $(screen).trigger(\"click\");\n  $(screen).val(\"-2\");\n  $(document).find(\"button#fbx\").trigger(\"click\");\n  $(screen).trigger(\"click\");\n  $(screen).val(\"125\");\n  $(document).find(\"#equals\").trigger(\"click\");\n\n  if($(screen).val() != \"Error\"){\n    return returnWithError(document,content,grade,\"Calculator should show \\\"Error\\\" when argument b is negative\");\n  }\n\n  //B=1\n  $(screen).trigger(\"click\");\n  $(screen).val(\"1\");\n  $(document).find(\"button#fbx\").trigger(\"click\");\n  $(screen).trigger(\"click\");\n  $(screen).val(\"125\");\n  $(document).find(\"#equals\").trigger(\"click\");\n\n  if($(screen).val() != \"Error\"){\n    return returnWithError(document,content,grade,\"Calculator should show \\\"Error\\\" when argument b is below 1\");\n  }\n\n  //B decimal\n  $(screen).trigger(\"click\");\n  $(screen).val(\"2.5\");\n  $(document).find(\"button#fbx\").trigger(\"click\");\n  $(screen).trigger(\"click\");\n  $(screen).val(\"125\");\n  $(document).find(\"#equals\").trigger(\"click\");\n\n  if($(screen).val() != \"Error\"){\n    return returnWithError(document,content,grade,\"Calculator should show \\\"Error\\\" when argument b is not natural\");\n  }\n\n  //X negativo\n  $(screen).trigger(\"click\");\n  $(screen).val(\"3\");\n  $(document).find(\"button#fbx\").trigger(\"click\");\n  $(screen).trigger(\"click\");\n  $(screen).val(\"-125\");\n  $(document).find(\"#equals\").trigger(\"click\");\n\n  if($(screen).val() != \"Error\"){\n    return returnWithError(document,content,grade,\"Calculator should show \\\"Error\\\" when argument 'x' is not a positive real number\");\n  }\n\n  //X decimal positivo\n  $(screen).trigger(\"click\");\n  $(screen).val(\"3\");\n  $(document).find(\"button#fbx\").trigger(\"click\");\n  $(screen).trigger(\"click\");\n  $(screen).val(\"125.5\");\n  $(document).find(\"#equals\").trigger(\"click\");\n\n  if($(screen).val() == \"Error\"){\n    return returnWithError(document,content,grade,\"Calculator should not show \\\"Error\\\" when argument 'x' is a positive real number.\");\n  }\n\n  //X=0\n  $(screen).trigger(\"click\");\n  $(screen).val(\"3\");\n  $(document).find(\"button#fbx\").trigger(\"click\");\n  $(screen).trigger(\"click\");\n  $(screen).val(\"0\");\n  $(document).find(\"#equals\").trigger(\"click\");\n\n  if($(screen).val() != \"Error\"){\n    return returnWithError(document,content,grade,\"Calculator should show \\\"Error\\\" when argument 'x' is 0\");\n  }\n\n  grade.score = 10;\n  grade.successes.push(\"Right.\");\n\n  resetState(document,content);\n  return grade;\n};\n\nvar returnWithError = function(document,content,grade,msg){\n  resetState(document,content);\n  grade.errors.push(msg);\n  return grade;\n};\n\nvar resetState = function(document,content){\n  if((typeof document != \"undefined\")&&(typeof document.documentElement != \"undefined\")&&(typeof content != \"undefined\")){\n\t  document.open();\n\t  document.writeln(content);\n\t  document.close();\n  }\n};","id":6},{"type":"exercise","title":"f) Error counter","description":"This section shows a modification of the calculator that displays the message <b>\"Error\"</b> when one of the operands entered is a text string instead of a number. Make the following changes:\n1) Add a <i><div></i> with a \"counter\" identifier that shows the number of errors in the calculator. The counter will start with the value 0 and increase by 1 each time an error is displayed on the calculator display.\n2) Make use of the <i>error</i> class defined in the <code><style></code> tag so that the \"Error\" messages are shown in red on the calculator screen, but the rest of the values are shown with the usual color.","editorMode":"HTML","content":"<!DOCTYPE html>\n<html>\n<head>\n\t<title>Calculator</title>\n\t<meta charset=\"utf-8\">\n  <script libname=\"jquery\" src=\"https://code.jquery.com/jquery-1.11.2.min.js\"></script>\n  <style type=\"text/css\">\n\t  .error {\n\t    color: red;\n\t  }\n\t</style>\n</head>\n<body>\n\n\t<div>\n\t\tNumber: <input type=\"text\" id=\"screen\"/>\n\t\t<button id=\"add\">+</button>\n\t\t<button id=\"equals\">=</button>\n\t</div>\n\n\t<script type=\"text/javascript\">\n\t\tvar acc = 0;\n\t\tvar op;\n\n\t\t$(document).ready(function(){\n\t\t\t$(\"#screen\").click(function(){\n\t\t\t\t$(this).val(\"\");\n\t\t\t});\n\t\t\t$(\"#add\").click(function(){\n\t\t\t\tacc = parseFloat($(\"#screen\").val());\n\t\t\t\top = \"+\";\n\t\t\t});\n\t\t\t$(\"#equals\").click(function(){\n\t\t\t\tvar n = parseFloat($(\"#screen\").val());\n\t\t\t\tif(op === \"+\"){\n\t\t\t\t\tacc += n;\n\t\t\t\t} else {\n\t\t\t\t\tacc = n;\n\t\t\t\t}\n\t\t\t\tif((typeof acc != \"number\")||(isNaN(acc))){\n\t\t\t\t\tacc = \"Error\";\n\t\t\t\t}\n\t\t\t\t$(\"#screen\").val(acc);\n\t\t\t\tacc = 0;\n\t\t\t\top = undefined;\n\t\t\t});\n\t\t});\n\t</script>\n</body>\n</html>","progress":{"score":0,"passed":false},"score_function":"var score = function(document){\n  var grade = {};\n  grade.score = 0;\n  grade.successes = [];\n  grade.errors = [];\n  grade.feedback = [];\n  \n  //Content\n  var content;\n  if((typeof document != \"undefined\")&&(typeof document.documentElement != \"undefined\")){\n    content = document.documentElement.outerHTML;\n  }\n  \n  //Existencia de elementos del DOM.\n  //Existencia de elementos del DOM.\n\tif($(document).find(\"input#screen\").length === 0){\n\t  \treturn returnWithError(document,content,grade,\"<input> with id 'screen' could not be found.\");\n\t}\n\tif($(document).find(\"button#add\").length === 0){\n\t  \treturn returnWithError(document,content,grade,\"<input> with id 'add' could not be found.\");\n\t}\n\tif($(document).find(\"button#equals\").length === 0){\n\t  \treturn returnWithError(document,content,grade,\"<input> with id 'equals' could not be found.\");\n\t}\n\t\n\tif($(document).find(\"div#counter\").length === 0){\n\t  \treturn returnWithError(document,content,grade,\"<div> with id 'counter' could not be found.\");\n\t}\n\tif(parseInt($(document).find(\"div#counter\").html()) !== 0){\n\t  \treturn returnWithError(document,content,grade,\"Counter should have a initial value of 0.\");\n\t}\n\t\n  var screen = $(document).find(\"input#screen\");\n  $(screen).trigger(\"click\");\n  $(screen).val(5);\n  $(document).find(\"#add\").trigger(\"click\");\n  $(screen).trigger(\"click\");\n  $(screen).val(2);\n  $(document).find(\"#equals\").trigger(\"click\");\n  \n  if(parseFloat($(screen).val()) != 7){\n    return returnWithError(document,content,grade,\"Add funtion does not work as expected.\");\n  }\n  \n  $(screen).trigger(\"click\");\n  $(screen).val(3);\n  $(document).find(\"#add\").trigger(\"click\");\n  $(screen).trigger(\"click\");\n  $(screen).val(7);\n  $(document).find(\"#equals\").trigger(\"click\");\n  \n  if(parseFloat($(screen).val()) != 10){\n    return returnWithError(document,content,grade,\"Add funtion does not work as expected.\");\n  }\n  \n  //Trigger error\n  $(screen).trigger(\"click\");\n  $(screen).val(\"Gato\");\n  $(document).find(\"#add\").trigger(\"click\");\n  $(screen).trigger(\"click\");\n  $(screen).val(\"Perro\");\n  $(document).find(\"#equals\").trigger(\"click\");\n  \n  if($(screen).val() != \"Error\"){\n    return returnWithError(document,content,grade,\"Calculator should show \\\"Error\\\" when any of the arguments is a string instead of a number.\");\n  }\n  \n  if(parseInt($(document).find(\"div#counter\").html()) != 1){\n\t  return returnWithError(document,content,grade,\"Counter should have a  value of 1 after the first Error.\");\n\t}\n\t\n\tvar errorsToTrigger = 5;\n\tfor(var i=0; i<errorsToTrigger; i++){\n  \t//Trigger error\n    $(screen).trigger(\"click\");\n    $(screen).val(\"Gato\");\n    $(document).find(\"#add\").trigger(\"click\");\n    $(screen).trigger(\"click\");\n    $(screen).val(\"Perro\");\n    $(document).find(\"#equals\").trigger(\"click\"); \n\t}\n\n  if($(screen).val() != \"Error\"){\n    return returnWithError(document,content,grade,\"Calculator should show \\\"Error\\\" when any of the arguments is a string instead of a number.\");\n  }\n  \n  if(parseInt($(document).find(\"div#counter\").html()) != (errorsToTrigger+1)){\n\t  return returnWithError(document,content,grade,\"Counter does not count Errors.\");\n\t}\n\t\n\tif(!$(screen).hasClass(\"error\")){\n    return returnWithError(document,content,grade,\"Screen should have class 'error' and show the text \\\"Error\\\".\");\n  }\n  \n  $(screen).trigger(\"click\");\n  $(screen).val(3);\n  if($(screen).hasClass(\"error\")){\n    return returnWithError(document,content,grade,\"Screen should only have class 'error' when showing the \\\"Error\\\" in each moment.\");\n  }\n  $(document).find(\"#add\").trigger(\"click\");\n  $(screen).trigger(\"click\");\n  $(screen).val(7);\n  $(document).find(\"#equals\").trigger(\"click\");\n  \n  if(parseFloat($(screen).val()) != 10){\n    return returnWithError(document,content,grade,\"Add function does not work after an error\");\n  }\n  \n  if($(screen).hasClass(\"error\")){\n    return returnWithError(document,content,grade,\"Screen should only have class 'error' when showing the \\\"Error\\\" in each moment.\");\n  }\n\n  grade.score = 10;\n  grade.successes.push(\"Correcto.\");\n\n  resetState(document,content);\n  return grade;\n};\n\nvar returnWithError = function(document,content,grade,msg){\n  resetState(document,content);\n  grade.errors.push(msg);\n  return grade;\n};\n\nvar resetState = function(document,content){\n  if((typeof document != \"undefined\")&&(typeof document.documentElement != \"undefined\")&&(typeof content != \"undefined\")){\n\t  document.open();\n\t  document.writeln(content);\n\t  document.close();\n  }\n};\n\n","id":7}],"metadata":{"title":"Calculator","language":"es"}}