//==========================================================================================================================
//Funciones que vamos a utilizar para inicializar elementos de nuestra aplicacion (Propio de Completar)
//==========================================================================================================================
   
//Extraemos del XML todos los datos necesarios para nuestra aplicacion

	function extraerDatos()
	{
		tipo_actividad = "Completar";
		
        try{
			origen_recursos = xmlDoc.getElementsByTagName("origen_recursos")[0].childNodes[0].nodeValue;
		}catch(e)
		{
			origen_recursos="";
		}
        
		if(origen_recursos){
			rutaRecursos = origen_recursos;
		}
		
		ocultar_reiniciar = xmlDoc.getElementsByTagName("ocultar_reiniciar")[0].childNodes[0].nodeValue;
		ocultar_respuestas = xmlDoc.getElementsByTagName("ocultar_respuestas")[0].childNodes[0].nodeValue;
		ocultar_redes = xmlDoc.getElementsByTagName("ocultar_redes")[0].childNodes[0].nodeValue;
        try{
        	colorFuente = xmlDoc.getElementsByTagName("color_fuente")[0].childNodes[0].nodeValue;
        	colorFuenteB = xmlDoc.getElementsByTagName("color_fuente_b")[0].childNodes[0].nodeValue;
        	colorFuenteInt = colorFuente.substring(2,colorFuente.length);
        	colorFuente = "#"+colorFuente.substring(2,colorFuente.length);
        	colorFuenteB = "#"+colorFuenteB.substring(2,colorFuenteB.length);
        }catch(e){
        	colorFuente = "#FFFFFF";
        	colorFuenteB = "#111111";
        }
        colorFondo = xmlDoc.getElementsByTagName("color_fondo_h")[0].childNodes[0].nodeValue;
				colorFondoInt = colorFondo.substring(2,colorFondo.length);
        colorFondo = "#"+colorFondo.substring(2,colorFondo.length);
				colorBotones = xmlDoc.getElementsByTagName("color_botones_h")[0].childNodes[0].nodeValue;
				colorBotones = colorBotones.substring(2,colorBotones.length);
        try{
        	logoPersonalizado = xmlDoc.getElementsByTagName("logoPersonalizado")[0].childNodes[0].nodeValue;
        }catch(e){
        	logoPersonalizado = "";
        }
        try{
        	franjaPersonalizada = xmlDoc.getElementsByTagName("franjaPersonalizada")[0].childNodes[0].nodeValue;
        }catch(e){
        	franjaPersonalizada = "";
        }
        
		forma_completar = xmlDoc.getElementsByTagName("forma_completar")[0].childNodes[0].nodeValue;
		if(forma_completar == "escribir")
		{
			if((xmlDoc.getElementsByTagName("sensible_mayusculas")[0].childNodes[0] != undefined)&&(xmlDoc.getElementsByTagName("sensible_mayusculas")[0].childNodes[0] != null)) sensible_mayusculas = xmlDoc.getElementsByTagName("sensible_mayusculas")[0].childNodes[0].nodeValue;
			else sensible_mayusculas = "no";
			if((xmlDoc.getElementsByTagName("sensible_acentos")[0].childNodes[0] != undefined)&&(xmlDoc.getElementsByTagName("sensible_acentos")[0].childNodes[0] != null)) sensible_acentos = xmlDoc.getElementsByTagName("sensible_acentos")[0].childNodes[0].nodeValue;
			else sensible_acentos = "no";
				
			if(xmlDoc.getElementsByTagName("sensible_mayusculas_ocultar")[0].childNodes[0] != undefined)
			{
				sensible_mayusculas_ocultar = xmlDoc.getElementsByTagName("sensible_mayusculas_ocultar")[0].childNodes[0].nodeValue;
			}
			else
			{
				sensible_mayusculas_ocultar = "no";
			}
			
			if(xmlDoc.getElementsByTagName("sensible_acentos_ocultar")[0].childNodes[0] != undefined)
			{
				sensible_acentos_ocultar = xmlDoc.getElementsByTagName("sensible_acentos_ocultar")[0].childNodes[0].nodeValue;
			}
			else
			{
				sensible_acentos_ocultar = "no";
			}
		}
		else
		{
			sensible_mayusculas_ocultar = "si";
			sensible_acentos_ocultar = "si";
			sensible_mayusculas = "noDefinido";
			sensible_acentos = "noDefinido";
		}
		
		numero_intentos = xmlDoc.getElementsByTagName("numero_intentos")[0].childNodes[0].nodeValue;
		puntos_resta = xmlDoc.getElementsByTagName("puntos_resta")[0].childNodes[0].nodeValue;
		
		if (xmlDoc.getElementsByTagName("autor")[0].childNodes.length == 0) {
			autor = '';
		} else {
			autor = xmlDoc.getElementsByTagName("autor")[0].childNodes[0].nodeValue;
		}
		descripcionUsuario = xmlDoc.getElementsByTagName("descripcionUsuario")[0].childNodes[0].nodeValue;
		
		registro = xmlDoc.getElementsByTagName("registro")[0];
		
		tiempo = xmlDoc.getElementsByTagName("tiempo")[0].childNodes[0].nodeValue;
		if(tiempo == "si") tiempo = xmlDoc.getElementsByTagName("tiempo")[0].attributes.getNamedItem("maximo").value;
		else if(tiempo == "no") tiempo = 0;
				
		descripcion = xmlDoc.getElementsByTagName("descripcion")[0].childNodes[0].nodeValue;
		enunciado = xmlDoc.getElementsByTagName("tituloAplicacion")[0].childNodes[0].nodeValue;
		
		tituloTexto = xmlDoc.getElementsByTagName("enunciado")[0].childNodes[0].nodeValue;
		
		texto = xmlDoc.getElementsByTagName("texto")[0].childNodes[0].nodeValue;
        
        if(texto.indexOf("&amp;#269;") > '0') try{texto = xmlDoc.getElementsByTagName("textoLimpio")[0].childNodes[0].nodeValue;}catch(e){texto=xmlDoc.getElementsByTagName("texto")[0].childNodes[0].nodeValue;}
        if(texto.indexOf("&amp;#268;") > '0') try{texto = xmlDoc.getElementsByTagName("textoLimpio")[0].childNodes[0].nodeValue;}catch(e){texto=xmlDoc.getElementsByTagName("texto")[0].childNodes[0].nodeValue;}
				
		ayuda = xmlDoc.getElementsByTagName("ayuda")[0].childNodes[0].nodeValue;
		
		//Creamos dos arrays con la informacion de las palabras
		pos = [];
		pa = [];
	
		var palab = xmlDoc.getElementsByTagName("palabra");
		
		for (i=0;i<palab.length;i++)
 		{
  			pos[i] = palab[i].childNodes[0].nodeValue;
  			pos[i] = parseInt(pos[i]);
  		}
  		//Ordenamos el array para que no de problemas
  		pos = pos.sort(ordAscModif);
  		
  		//Cadena de caracteres a quitar de las palabras para colocar en los huecos
  		var caracteresQuitar = '.,;:=*+-_{}[]¿?¡!()/&%$·|\@#"';
  		var sumale = 0;
  		for (i=0;i<palab.length;i++)
 		{
  		  	parteCadena = texto.substring(pos[i],texto.length);
  		  	parteCadena = parteCadena.replace("\n"," ");
  			pa[i] = parteCadena.split(" ")[0];
  			for(l=0;l<caracteresQuitar.length;l++)
  			{
  				pa[i] = pa[i].split(caracteresQuitar[l])[0];
  			}
  		}

		var idioma = xmlDoc.getElementsByTagName("idioma")[0];
		nIntentos = idioma.getElementsByTagName("nIntentos")[0].childNodes[0].nodeValue;
		txtPuntos = idioma.getElementsByTagName("txtPuntos")[0].childNodes[0].nodeValue;
		txtTiempo = idioma.getElementsByTagName("txtTiempo")[0].childNodes[0].nodeValue;
		txtTiempoRestante = idioma.getElementsByTagName("txtTiempoRestante")[0].childNodes[0].nodeValue;
		

		
		comprobar = idioma.getElementsByTagName("comprobar")[0].childNodes[0].nodeValue;
		txtRespuestaIncorrecta = idioma.getElementsByTagName("txtRespuestaIncorrecta")[0].childNodes[0].nodeValue;
		txtActNoSuperada = idioma.getElementsByTagName("txtActNoSuperada")[0].childNodes[0].nodeValue;
		txtTiempoSuperado = idioma.getElementsByTagName("txtTiempoSuperado")[0].childNodes[0].nodeValue;
		txtCerrar = idioma.getElementsByTagName("txtCerrar")[0].childNodes[0].nodeValue;
		txtRespuestaCorrecta = idioma.getElementsByTagName("txtRespuestaCorrecta")[0].childNodes[0].nodeValue;
		txtTituloRespuestaCorrecta = idioma.getElementsByTagName("txtTituloRespuestaCorrecta")[0].childNodes[0].nodeValue;
		txtSuperadoNumeroIntentos = idioma.getElementsByTagName("txtSuperadoNumeroIntentos")[0].childNodes[0].nodeValue;
		

		
		txtTituloSuperadoNumeroIntentos = idioma.getElementsByTagName("txtTituloSuperadoNumeroIntentos")[0].childNodes[0].nodeValue;
		txtBoxRespuestaCorrecta = idioma.getElementsByTagName("txtBoxRespuestaCorrecta")[0].childNodes[0].nodeValue;
		txtSensibleMayusculas = idioma.getElementsByTagName("txtSensibleMayusculas")[0].childNodes[0].nodeValue;
		txtNoSensibleMayusculas = idioma.getElementsByTagName("txtNoSensibleMayusculas")[0].childNodes[0].nodeValue;
		txtSensibleAcentos = idioma.getElementsByTagName("txtSensibleAcentos")[0].childNodes[0].nodeValue;
		txtNoSensibleAcentos = idioma.getElementsByTagName("txtNoSensibleAcentos")[0].childNodes[0].nodeValue;


   		txtTituloPalabrasParaCompletar = idioma.getElementsByTagName("txtTituloPalabrasParaCompletar")[0].childNodes[0].nodeValue;
   		txtMsgNoCompleta = idioma.getElementsByTagName("txtMsgNoCompleta")[0].childNodes[0].nodeValue;
		txtMsgNoCorrecta = idioma.getElementsByTagName("txtMsgNoCorrecta")[0].childNodes[0].nodeValue;
		txtPalabraYaIntroducida = idioma.getElementsByTagName("txtPalabraYaIntroducida")[0].childNodes[0].nodeValue;
		txtPalabraIncorrecta = idioma.getElementsByTagName("txtPalabraIncorrecta")[0].childNodes[0].nodeValue;
		
		txtAceptar = idioma.getElementsByTagName("txtAceptar")[0].childNodes[0].nodeValue;
		txtTiempoMaximo = idioma.getElementsByTagName("txtTiempoMaximo")[0].childNodes[0].nodeValue;
		txtSensible = idioma.getElementsByTagName("txtSensible")[0].childNodes[0].nodeValue;
		txtMayusculasMinusculas = idioma.getElementsByTagName("txtMayusculasMinusculas")[0].childNodes[0].nodeValue;
		txtAcentos = idioma.getElementsByTagName("txtAcentos")[0].childNodes[0].nodeValue;
		txtComenzar = idioma.getElementsByTagName("txtComenzar")[0].childNodes[0].nodeValue;
		txtAutor = idioma.getElementsByTagName("txtAutor")[0].childNodes[0].nodeValue;
		txtAyuda = idioma.getElementsByTagName("txtAyuda")[0].childNodes[0].nodeValue;
		txtMostrarMas = idioma.getElementsByTagName("txtMostrarMas")[0].childNodes[0].nodeValue;
		txtMostrarMenos = idioma.getElementsByTagName("txtMostrarMenos")[0].childNodes[0].nodeValue;
		txtReiniciar = idioma.getElementsByTagName("txtReiniciar")[0].childNodes[0].nodeValue;
		txtVolverJugar = idioma.getElementsByTagName("txtVolverJugar")[0].childNodes[0].nodeValue;
		txtResponder = idioma.getElementsByTagName("txtResponder")[0].childNodes[0].nodeValue;
		txtRegistrarse = idioma.getElementsByTagName("txtRegistrarse")[0].childNodes[0].nodeValue;
		txtAcceder = idioma.getElementsByTagName("txtAcceder")[0].childNodes[0].nodeValue;
		txtCompartirResultado = idioma.getElementsByTagName("txtCompartirResultado")[0].childNodes[0].nodeValue;
		txtAumentar = idioma.getElementsByTagName("txtAumentar")[0].childNodes[0].nodeValue;
		txtReducir = idioma.getElementsByTagName("txtReducir")[0].childNodes[0].nodeValue;
		txtImprimir = idioma.getElementsByTagName("txtImprimir")[0].childNodes[0].nodeValue;
		txtPantallaCompleta = idioma.getElementsByTagName("txtPantallaCompleta")[0].childNodes[0].nodeValue;
		txtSocial = idioma.getElementsByTagName("txtSocial")[0].childNodes[0].nodeValue;
	}

//Funcion para ordenar el array
	
	function ordAscModif(a,b)
	{
		if (a < b) return -1;
		if (a > b) return 1;
		if (a = b) return 0;
	}
	
//Inicializamos los diferentes elementos de nuestra aplicacion
	
	function inicializarElementos()
	{
	    //Inicializamos los colores de la aplicacion
		inicializarColores();
		//Inicializamos eventos principales
		inicializarEventosPrincipales();
		//Inicializamos los valores para la pantalla inicial
		inicializarPantallaInicial();
		//Inicializamos los valores para la barra de la pista
		inicializarTitulosCajas();
		//Inicializamos los parametros
		inicializarParametros();
		//Inicializamos el titulo de la propia aplicacion
		inicializarTituloAct();
		//Inicializar ayuda palabras
		inicializarAyudaPalabras();
		//Inicializamos el evento del boton comprobar
		inicializarBtnComprobar();
		//Inicializamos la alerta correcta
		inicializarAlertaCorrecta();
		//Inicializar alerta incorrecta
		inicializarAlertaIncorrecta();
		//Inicializamos enlaces reinicio
		inicializarRecargar();
		//Inicializamos enlaces ayuda
		inicializarAyuda();
		//Inicializamos el registro
		inicializarRegistro();	
	}

//Inicializamos los eventos principales

	function inicializarEventosPrincipales()
	{
		//Activamos la redimensión del crucigrama al cambiar el tamaño de la ventana 
		$(window).resize(function () {redimensionar();});
	}

//Inicializamos los elementos particulares de esta aplicación

//Inicializamos la pista de la palabra
	
	function inicializarTitulosCajas()
	{
		$("#tituloPalabras").text(txtTituloPalabrasParaCompletar);
		$("#tituloPalabrasOrdenar").text(tituloTexto);
	}
	
//Inicializamos la parte de las palabras en funcion de si se ha seleccionado ayuda o no

	function inicializarAyudaPalabras()
	{
		if(forma_completar == "escribir")
		{
			if(ayuda == "no")
			{
				$("#palabras").hide();
				$("#wrapper").addClass("width100");
			}
		}
	}
	
//Inicializamos el boton de comprobar
	
	function inicializarBtnComprobar()
	{
		$('#btnComprobar').text(comprobar);
		$('#btnComprobar').click(function(e){e.preventDefault();compruebaTexto();});
	}
