//==========================================================================================================================
//Funciones que vamos a utilizar cuando el usuario comienza a interactuar con esta aplicacion (Propio de Ordenar Palabras)
//==========================================================================================================================

//Oculta la parte de presentación de instrucciones y accede a la aplicacion

var respuestasSecuencia = [];

    function comenzar()
    {	
        numeroIntentos=0;
     	$('#contentPreActividad').hide();
     	$('#contentAct').css('top',0);
		
		//Focalizamos el campo de escribir
		if((forma_completar == "escribir")&&(!is_touch_device())) $("#ctrlInput").focus();
		
		//Lanzamos el contador de tiempo
		idInterval = setInterval(contador,1000);
   	}
   	
//Redimensionamos la aplicacion al cambiar de tamaño la pantalla

	function redimensionar()
	{	
		//Reinicializamos la descripción Inicial de Usuario
		cargarDescripcionInicio();
		
		//Tamaño del hueco sobre el que posicionamos la solución
		if($("#all").width() > 460)
		{ 
			$("#hueco00").css("height","64px"); 
			if(forma_completar == "escribir") 
			{
				$("#ctrlInput").css("height","64px");
			}
		}
		else 
		{ 
			$("#hueco00").css("height","56px");
			if(forma_completar == "escribir") 
			{
				$("#ctrlInput").css("height","56px");
			}
		}
		calculaAltura();
	}

//Reproducimos la pista de audio
var compruebaFin = 0;
	
	function reproducir(media,icono)
	{
		try{document.getElementById(media).currentTime = 0;}catch(e){}
		document.getElementById(media).pause();
		if(document.getElementById(media).currentTime != 0) document.getElementById(media).load();
		document.getElementById(media).play();
		$("#"+icono).removeClass("iPlay");
		$("#"+icono).addClass("iPause");
		
		clearInterval(compruebaFin);
		compruebaFin = setInterval(function(){controlFinalAudio(media,icono);},500);
	}

//Gestionamos el toogle entre play y pause que es controlado por el mismo botón
	
	function gestionReproducir(media,icono)
	{
		if($("#"+icono).hasClass("iPlay"))
		{
			$("#"+icono).removeClass("iPlay");
			$("#"+icono).addClass("iPause");
			reproducir(media,icono);
		}
		else
		{
			$("#"+icono).addClass("iPlay");
			$("#"+icono).removeClass("iPause");
			document.getElementById(media).pause();
		} 
	}

//Coontrolamos y gestionamos cuando termina de reproducirse la pista de audio
	
	function controlFinalAudio(media,icono)
	{
		if(document.getElementById(media).ended)
		{
			$("#"+icono).addClass("iPlay");
			$("#"+icono).removeClass("iPause");
			clearInterval(compruebaFin);
		}
	}
	
//Funcion que controla el tipo de error cuando no disponemos del audio			
	
	function errores(tipo)
	{
		if(tipo == -1)
		{
			$('#errorAudio').show();
			$('#audioOK').hide();
			$('#errorAudio').attr("title",txtErrorAudio);
		}
		else if(tipo == -2)
		{
			$('#errorAudioF').show();
			$('#audioOKF').hide();
			$('#errorAudioF').attr("title",txtErrorAudio);
		}
	}
	
	
//Funciones para "arrastrar" ------------------------------------------------------------------------------------------------	

//Funciones para arrastrar el elemento mediante Drag&Drop	

//Función de comienzo del arrastre

	function empezar(ev)
	{
		ev.dataTransfer.effectAllowed = 'move';
		ev.dataTransfer.setData("Text", ev.target.getAttribute('id'));
		return true;
	}

//Función para cuando nos colocamos sobre el contenedor donde vamos a arrastrar
	
	function encima(ev)
	{
		return false;
	}

//Función que se ejecuta al soltar el elemento arrastrado
	
	function soltar(ev)
	{
		var arrastraId = ev.dataTransfer.getData("Text");
		var contenedorId = ev.target.getAttribute('id');
		var contenedorPadreId = $("#"+contenedorId).parent().attr("id");
		if(contenedorId == "hueco00")
		{
			$("#"+arrastraId).css("display","inline-block");
			ev.target.appendChild(document.getElementById(arrastraId));
		}
		else if((contenedorId.substring(0,16) == "cajaPalabraFondo")||(contenedorId == "palabrasDisponibles"))
		{
			$("#"+arrastraId).css("top",0).css("left",0);
			$("#"+arrastraId).appendTo($("#cuadro"+arrastraId.substring(11,13)));
		}
		else if((contenedorPadreId == "hueco00")&&(contenedorId.substring(0,11) == "cajaPalabra"))
		{
			$("#"+arrastraId).insertBefore("#"+contenedorId);
		}
		
		//Actualizamos la altura del hueco sobre el que construimos la frase
		calculaAltura();
			
		ev.stopPropagation();
		return false;
	}

//Función de finalización del arrastre
	
	function terminar(ev)
	{
		ev.dataTransfer.clearData("Data");
		return true;
	}

//Funciones para arrastrar el elemento de manera manual	

//Comenzamos el proceso de arrastrar al activar el raton sobre cualquier elemento cajaLetra
	
	function comienzaArrastre(ev)
	{
		$(".res").removeClass("mal");
		idArrastre = ev.target.getAttribute('id');
		posX0 = ev.clientX;
		posY0 = ev.clientY;
		$("#contentAct").mousemove(mueveElemento);
		$("#contentAct").mouseout(devuelveElemento);
	}
	
//Desplazamos el elemento cajaLetra a la posición del ratón

	function mueveElemento(ev)
	{
		var posX = ev.clientX-posX0;
		var posY = ev.clientY-posY0;
		$("#"+idArrastre).css("top",posY).css("left",posX).css("z-index","10");
	}

//Cuando nos salimos de los limites arrastrando un elemento lo devolvemos a su sitio original

	function devuelveElemento()
	{
		$("#"+idArrastre).appendTo($("#cuadro"+idArrastre.substring(11,13)));
		$("#"+idArrastre).css("top",0).css("left",0);
		$("#contentAct").unbind("mousemove");
		$("#contentAct").unbind("mouseout");
	}	
	
//Soltamos el elemento al soltar el ratón

	function terminaArrastre(ev)
	{
		var asignado = 0; 
		$("#all").unbind("mousemove");
		
		$("#"+idArrastre).css("z-index","8");
		$("#"+idArrastre).hide();
		var posXS = parseInt($("#"+idArrastre).css("left"),10)-50;
		var posYS = parseInt($("#"+idArrastre).css("top"),10)-50;
		$("#"+idArrastre).css("top",posYS).css("left",posXS);
		
		setTimeout(function(){
			
			$("#"+idArrastre).show();
			if(idArrastre == idSoltar)
			{
				$("#"+idArrastre).appendTo($("#cuadro"+idArrastre.substring(11,13)));
				$("#"+idArrastre).css("top",0).css("left",0);
			}
			else
			{
				$("#"+idArrastre).css("display","inline-block");
				if(activadoContenedor == 0)
				{
					$("#"+idArrastre).css("top",0).css("left",0);	
				}
				else
				{
					if(idSoltar == "palabras")
					{			
						$("#"+idArrastre).appendTo($("#cuadro"+idArrastre.substring(11,13)));
						$("#"+idArrastre).css("top",0).css("left",0);
					}
					else if(idSoltar.substring(0,4) == "caja")
					{
						if(idSoltarPadre.substring(0,6) != "cuadro")
						{
							$("#"+idArrastre).css("top",0).css("left",0);
							$("#"+idArrastre).insertBefore("#"+idSoltar);	
						}
						else
						{
							$("#"+idArrastre).appendTo($("#cuadro"+idArrastre.substring(11,13)));
							$("#"+idArrastre).css("top",0).css("left",0);
						}
					}
					else
					{
						$("#"+idArrastre).appendTo($("#"+idSoltar));
						$("#"+idArrastre).css("top",0).css("left",0);
					}
				}
			}
			
			$("#contentAct").unbind("mousemove");
			$("#contentAct").unbind("mouseout");
			
			//Actualizamos la altura del hueco sobre el que construimos la frase
			calculaAltura();
		},20);
	}

//Activamos la posibilidad de soltar, si estamos sobre un elemento sobre el que permitimos soltar
//Esta variable controla si podemos soltar o no
var activadoContenedor = 0;

	function activarSoltar(ev)
	{
		idSoltar = ev.target.getAttribute('id');
		idSoltarPadre = $("#"+idSoltar).parent().attr("id");
		
		if((idSoltar == "tituloPalabras")||(idSoltar == "palabrasDisponibles")||(idSoltar.substring(0,6) == "cuadro")||(idSoltar.substring(0,16) == "cajaPalabraFondo")) idSoltar = "palabras";
		activadoContenedor = 1;
	}

//Desactivamos la opción de soltar, si salimos de los elementos sobre los que permitimos soltar

	function desactivarSoltar()
	{
		activadoContenedor = 0;
	}


//Funciones para "clickar" -----------------------------------------------------------------------------------------------------	

//Movemos la palabra al lugar que le corresponde cualdo hacemos click sobre ellas
//En esta variable controlamos que elementos estan ya colocados en los huecos y en que orden
var control = [];

	function mover(ev)
	{
		$(".res").removeClass("mal");
		var encontrado = 0;
		var mueveId = ev.target.getAttribute('id');
		var mueveEle = document.getElementById(mueveId);
		var mueveCad = mueveId.substring(11,13);
	
		for(i=0;i<control.length;i++)
		{
			if(control[i] == mueveId)
			{
				$(mueveEle).insertBefore("#cajaPalabraFondo"+mueveCad);
				control[i] = "";
				encontrado = 1;
			}
		}
	
		if(encontrado == 0)
		{
			var cantidad = control.length;
		
			for(i=0;i<cantidad;i++)
			{
				if(control[i] == "")
				{
					cantidad = i;
					break;
				}
			}
	
			if(cantidad<10) var cantidadx = "0"+cantidad;
			else var cantidadx = cantidad;
			
			$("#hueco00").append(mueveEle);
			control[cantidad] = mueveId;
			cantidad++;
		}
		
		for(p=0;p<respuesta.length;p++)
		{
			if(p<10) var px = "0"+p;
			else px = p;	
			
			if(!$("#hueco"+px).find("div").html()) $("#hueco"+px).removeClass("completo");
		}
		
		//Actualizamos la altura del hueco sobre el que construimos la frase
		calculaAltura();
	}


//Funciones para "escribir" -----------------------------------------------------------------------------------------------------
	
//Controlamos los caracteres permitidos
//Controlamos las flechas del teclado para que nos podamos mover a través de ellas por las cajas
//Controlamos la tecla de borrar hacia atras, para que salte al hueco anterior
	
	function limitar(e)
	{	
		var evento = e || window.e;
		
		key = evento.keyCode;
		if(evento.keyCode == 39) 
		{
			e.preventDefault();
			mueve("d");
			return true;
		}
		else if(evento.keyCode == 37) 
		{
			e.preventDefault();
			mueve("i");
			return true;
		}
		else if((evento.keyCode == 32)||(evento.keyCode == 13)) 
		{
			e.preventDefault();
			compruebaPalabra(key);
			return false;
		}
		else if(evento.keyCode == 8) 
		{
			if($("#campoEscribir").html() == ""){e.preventDefault(); borra();}
			compruebaPalabra(key);
			return true;
		}
		else
		{
			return true;
		}
	}

//Borramos o saltamos al elemento anterior para poder borrar

	function borra(e)
	{	
		contadorp = controlIds[controlIds.length-1];
		
		if(controlPosicion != -1) { contadorp = controlIds[controlPosicion-1]; controlPosicion--;}
		
		if(contadorp<10) var contadorx = "00"+contadorp;
		else if(contadorp<100) var contadorx = "0"+contadorp;
		else contadorx = contadorp;
		
		$("#campoEscribir").html($("#cajaPalabraF"+contadorx).html());
		
		$("#ctrlInput").val($("#cajaPalabraF"+contadorx).html());
		$("#ctrlInput").focus();
		
		$("#cajaPalabraF"+contadorx).remove();
		
		controlCajas[contadorp] = 0;
		actualizaIds();
	}
	
//Actualizamos contenido al hacer click sobre una de las cajas escritas en el hueco
var controlPosicion = -1;

	function cambiarContenido(e)
	{	
		if($("#campoEscribir").html() != "")
		{
			compruebaPalabra(0);
		}
		
		setTimeout(function(){
			var idA = e.target.getAttribute('id'); 	
			var cadenaIdA = idA.substring(12,15);
			var numIdA = parseInt(cadenaIdA,10);
			
			//Buscar posicion del elemento eliminado
			for(i=0;i<controlIds.length;i++)
			{
				if(controlIds[i] == numIdA)
				{
					controlPosicion = i;
				}
			}
		
			$("#campoEscribir").html($("#cajaPalabraF"+cadenaIdA).html());
		
			$("#campoEscribir").insertBefore(("#cajaPalabraF"+cadenaIdA));
			$("#cajaPalabraF"+cadenaIdA).remove();
		
			controlCajas[numIdA] = 0;
			actualizaIds();
		
			$("#ctrlInput").val($("#campoEscribir").html());
			$("#ctrlInput").focus();
		},20);
	}

//Al clickar dentro del hueco en cualquier lugar, ponemos el cursor al final de la frase	
	
	function ponerAlFinal()
	{
		if($("#campoEscribir").html() != "")
		{
			compruebaPalabra(0);
		}
		
		var final = controlIds[controlIds.length-1];
		
		if(final<10) var finalx = "00"+final;
		else if(final<100) var finalx = "0"+final;
		else finalx = final;
		
		$("#campoEscribir").insertAfter(("#cajaPalabraF"+finalx));
		
		controlPosicion = -1;
	}		
					
//Nos movemos por las casillas al pulsar las teclas de movimiento

	function mueve(dir)
	{	
		if(dir == "d")
		{	
			if((controlPosicion != -1)&&(controlPosicion < controlIds.length)) controlPosicion++;
		}
	
		contadorp = controlIds[controlIds.length-1];
		if(controlPosicion != -1) { contadorp = controlIds[controlPosicion-1];}
		
		if(contadorp<10) var contadorx = "00"+contadorp;
		else if(contadorp<100) var contadorx = "0"+contadorp;
		else contadorx = contadorp;

		$("#cajaPalabraF"+contadorx).click();
	}
	
//Comprobamos la palabra escrita y en caso de error lo marcamos
//Variables necesarias para el control de los elementos del hueco
var controlP = [];
var controlH = [];
var controlCajas = [];
var controlIds = [];
var contadorp = 0;

	function compruebaPalabra(key)
	{	
		if((key != 8)&&($("#campoEscribir").html()!=""))
		{		
			var contenido = $("#campoEscribir").html();
			contadorp = controlCajas.length;
			
			if(contadorp<10) var contadorx = "00"+contadorp;
			else if(contadorp<100) var contadorx = "0"+contadorp;
			else contadorx = contadorp;
			
			var divPalabra = $("<div>",
			{
				id: "cajaPalabraF"+contadorx,
				"class": "cajaPalabras res"
			});
			$('#hueco00').append(divPalabra);
			$("#cajaPalabraF"+contadorx).insertBefore("#campoEscribir");
			$("#cajaPalabraF"+contadorx).html(contenido);
			$(".res").click(cambiarContenido);
			
			if(sensible_mayusculas == "no")
			{	 
				contenido = contenido.toUpperCase();
				respuestaT = respuestaT.toUpperCase();
			}
		
			if(sensible_acentos == "no")
			{ 
				contenido = borraAcentos(contenido);
				respuestaT = borraAcentos(respuestaT);
			}
		
			var respuestaOriginal = respuesta;
			respuesta = respuestaT.split(" ");
			var encontrado = 0;
		
			for(j=0;j<respuesta.length;j++)
			{
				if(contenido == respuesta[j])
				{
					encontrado = 1;
				}
			}
		
			if(encontrado == 1)
			{
				$("#cajaPalabraF"+contadorx).addClass("completo");
			}
			else
			{
				$("#cajaPalabraF"+contadorx).addClass("mal");	
			}
			
			$("#campoEscribir").html("");
			$("#ctrlInput").val("");
			
			controlCajas[contadorp] = 1;
			actualizaIds();
			respuesta = respuestaOriginal;
		}
		
		controlL = [];
		controlH = [];
		$(".cajaPalabras").removeClass("used");
		for (m=0;m<respuesta.length;m++)
		{
			if(m<10) var mx = "0"+m;
			else mx = m;
			
			for(p=0;p<controlCajas.length;p++)
			{
				if(controlCajas[p] == 0) continue;
					
				if(p<10) var px = "00"+p;
				else if(p<100) var px = "0"+p;
				else px = p;
			
				if(controlH[p] == 1) continue;
				
				contenidoC = $("#cajaPalabraF"+px).html();
				respuestaC = $("#cajaPalabra"+mx).html();
				
				if (contenidoC == "&nbsp;") contenidoC = " ";
				
				if(sensible_mayusculas == "no")
				{	 
					contenidoC = contenidoC.toUpperCase();
					respuestaC = respuestaC.toUpperCase();
				}
		
				if(sensible_acentos == "no")
				{	 
					contenidoC = borraAcentos(contenidoC);
					respuestaC = borraAcentos(respuestaC);
				}
				
				if(respuestaC == contenidoC)
				{
					if(controlL[m] != 1)
					{
						$("#cajaPalabra"+mx).addClass("used");
						controlL[m] = 1;
						controlH[p] = 1;
					}
				}
			}
		}
	
	}
	
//En caso de que la aplicacion no sea sensible a acentos, eliminamos los acentos antes de comparar las cadenas
	
	function borraAcentos(cadenaQuitar) 
	{  
     	var conAcentos= "áàãâäéèêëíìîïóòõôöúùûüçÁÀÃÂÄÉÈÊËÍÌÎÏÓÒÕÖÔÚÙÛÜÇ";  
        var sinAcentos = "aaaaaeeeeiiiiooooouuuucAAAAAEEEEIIIIOOOOOUUUUC";  
        var nueva = "";
        var encontrada = 0;
        for(i=0;i<cadenaQuitar.length;i++) 
        {	
        	encontrada = 0;  
        	for(j=0;j<conAcentos.length;j++)
        	{
             	if(cadenaQuitar[i] == conAcentos[j])
                {
                	nueva += sinAcentos[j];
                	encontrada = 1;
                	break;
                } 
       		}
       		if(encontrada == 0) nueva += cadenaQuitar[i]; 	  
    	}
     	return nueva;   
 	} 


//Funciones generales -------------------------------------------------------------------------------------------------

//Actualizamos el array que contiene los identificadores de los elementos que hay en el hueco en orden 

	function actualizaIds()
	{
		var i = 0;
		var inicio = 11;
		var final = 13;
		if(forma_completar == "escribir") {inicio = 12; final = 15;}
		
		controlIds = [];
		$("#hueco00 .res").each(function (){
			controlIds[i] = $(this).attr("id");
			controlIds[i] = parseInt(controlIds[i].substring(inicio,final),10);
			i++;
		})
		calculaAltura();
	}

//Calculamos la altura del hueco

	function calculaAltura()
	{
		var anchura = 0;
		var filas = 1;
		$("#hueco00 .res").each(function (){
			anchura = anchura + $(this).width() + 23;
			if(anchura > $("#hueco00").width()) { filas++; anchura = $(this).width(); }
		})
		
		filas++;
		if(filas >= 2)
		{
			if($("#all").width() > 460)
			{ 
				$("#hueco00").css("height",(32*filas)+"px"); 
				if(forma_completar == "escribir") 
				{
					$("#ctrlInput").css("height",(32*filas)+"px");
					$("#ctrlInput").css("margin-top",(-32*filas)+"px");
				}
			}
			else 
			{	 
				$("#hueco00").css("height",(28*filas)+"px");
				if(forma_completar == "escribir") 
				{
					$("#ctrlInput").css("height",(28*filas)+"px");
					$("#ctrlInput").css("margin-top",(-28*filas)+"px");
				}
			}
		}
		
	}


//Actualizamos los intentos
	
	function actualizarIntentos()
	{
		var cadenaIntentos = $('#numIntentos').text();
		var pos = cadenaIntentos.indexOf("/");
		numeroIntentos = parseInt(cadenaIntentos.substring(0,pos+1));
		if(numeroIntentos <= numero_intentos-1)
		{
			numeroIntentos++;
			cadenaIntentos = numeroIntentos+"<sup>/"+numero_intentos+"</sup>";
			$('#numIntentos').html(cadenaIntentos);
			$('#cajaIntentos').addClass('alertLuz');
			setTimeout(function(){$('#cajaIntentos').removeClass('alertLuz');},1000);
		}
		
		if(numeroIntentos == numero_intentos)
		{
			$('#btnComprobar').unbind("click");
			cargarPantallaFinal('intentos',getDatosRespuestas(0));
			puntosReg = 0;
			$("#numPuntos").html("0");
		}
	}
	
//Actualizar puntos en funcion de los fallos
var puntosReg = 100;

	function actualizaPuntos()
	{
		var actuales = parseInt(puntosReg);
		var descuento = puntos_resta;
		var cantidadActual =  actuales - descuento;
		if(cantidadActual < 0) cantidadActual = 0;
		puntosReg = parseInt(cantidadActual);
		$("#numPuntos").html(parseInt(cantidadActual));
	}

//Corregios la solucion que ha propuesto el usuario
var controlCorreccion = [];

	function compruebaFrase()
	{
		var respuestaDada = {};
		respuestaDada['a'] = '';
		if(forma_completar == "escribir")
		{
			if($("#campoEscribir").html() != "") compruebaPalabra(0);
		}
		
		//Comprobar si el contenido introducido es el correcto palabra por palabra
		var error = 0;
		var i = 0;
		var contenido = "";
		
		$("#hueco00 .res").each(function (){
			
			contenido = $(this).html();
			if(i >= respuesta.length) respuestaF = "";
			else respuestaF = respuesta[i];
				
			if(forma_completar == "escribir")
			{
				if(sensible_mayusculas == "no")
				{ 
					contenido = contenido.toUpperCase();
					respuestaF = respuestaF.toUpperCase();
				}
		
				if(sensible_acentos == "no")
				{	 
					contenido = borraAcentos(contenido);
					respuestaF = borraAcentos(respuestaF);
				}
			}
			else
			{
				if(contenido != undefined) contenido = contenido.toUpperCase();
				respuestaF = respuestaF.toUpperCase();
			}
				
			if(respuestaF != contenido)
			{
				controlCorreccion[i] = 0;
				error = 1;
			}
			else
			{
				controlCorreccion[i] = 1;
			}
			respuestaDada['a'] += contenido + ' ';
			i++;
		});
		respuestaDada['a'] = respuestaDada['a'].trim();
		if((error == 1)||(i != respuesta.length))
		{
			respuestaDada['s'] = 0;
			respuestasSecuencia.push(respuestaDada);
			for(i=0;i<controlCorreccion.length;i++)
			{	
				if(forma_completar == "escribir")
				{
					var pos = controlIds[i];
					if(pos<10) var posx = "00"+pos;
					else if(pos<100) var posx = "0"+pos;
					else var posx = pos;
				
					if(controlCorreccion[i] == 0) $("#cajaPalabraF"+posx).addClass("mal");
				}
				else
				{
					var pos = controlIds[i];
					if(pos<10) var posx = "0"+pos;
					else var posx = pos;
					
					if(controlCorreccion[i] == 0) $("#cajaPalabra"+posx).addClass("mal");
				}
			}
			actualizarIntentos();
			actualizaPuntos();
		} 
		else if(error == 0)
		{
			respuestaDada['s'] = 1;
			respuestasSecuencia.push(respuestaDada);
			$('#btnComprobar').unbind("click");
            numeroIntentos++;
			cargarPantallaFinal('OK',getDatosRespuestas(1));
		}
	}
	
//Completamos la pantalla final con la corrección de la palabra

	function completarPantallaFinal()
	{		
		for(i=0;i<respuesta.length;i++)
		{
			if(i<10) var ix = "0"+i;
			else var ix = i;
						
			var divCorrecto = $("<div>",
			{
				id: "cuadroFinalC"+ix,
				"class": "cuadroPalabras"
			});
			$('#correccion').append(divCorrecto);
			
			if((controlCorreccion[i] == 0)||(controlCorreccion[i] == undefined))
			{
				var divError = $("<div>",
				{
					id: "cuadroFinalE"+ix,
					"class": "palabraCorreccion"
				});
				$('#cuadroFinalC'+ix).append(divError);
			} 
					
			var divRespuesta = $("<div>",
			{
				id: "cuadroFinalR"+ix,
				"class": "cajaPalabras"
			});
			$('#cuadroFinalC'+ix).append(divRespuesta);	
		}
		cargarFinal();
		cargarPistaF();
	}

//Cargamos el resultado en la pantalla final	
	
	function cargarFinal()
	{
		for(i=0;i<respuesta.length;i++)
		{
			if(i<10) var ix = "0"+i;
			else var ix = i;
			
			if(forma_completar == "escribir")
			{
				var pos = controlIds[i];
				if(pos<10) var posx = "00"+pos;
				else if(pos<100) var posx = "0"+pos;
				else var posx = pos;
				var contenidoI = $("#cajaPalabraF"+posx).html();
			}
			else
			{
				var pos = controlIds[i];
				if(pos<10) var posx = "0"+pos;
				else var posx = pos;
				var contenidoI = $("#cajaPalabra"+posx).html();
			}
	
			if((controlCorreccion[i] == 0)||(controlCorreccion[i] == undefined))
			{
				if(pos == undefined) $('#cuadroFinalE'+ix).html("");
				else $('#cuadroFinalE'+ix).html(contenidoI);
				$("#cuadroFinalC"+ix).addClass("mal");
			} 
			$('#cuadroFinalR'+ix).html(respuesta[i]);
		}
	}

//Cargamos la pista en la pantalla final
	
	function cargarPistaF()
	{
		$('#pTextoF').html(pregunta);
		
		if(audio == "")
		{
			$("#pAudioF").hide();
		} 
		else
		{	
			var rutaAudio = rutaRecursos+audio;
            var rutaAudioOgg = rutaRecursosInicio+audio;
			//var audioCadena = "<audio id='pistaAudioF' src='"+rutaAudio+"' type='audio/mpeg' onError='errores(-2);'></audio>";
			var audioCadena = "<audio id='pistaAudioF'><source src='"+rutaAudio+"' type='audio/mpeg'></source><source src='"+rutaAudio.substring(0,rutaAudio.length-3)+"ogg' type='audio/ogg'></source><source src='"+rutaAudioOgg.substring(0,rutaAudioOgg.length-3)+"ogg' onError='errores(-2);' type='audio/ogg'></source></audio>";
			$('#audioTagF').html(audioCadena);
			$('#btnAudioF').show();
			$('#btnAudioF').click(function(e){e.preventDefault();gestionReproducir("pistaAudioF","iconoAudioF");});
		}
		
		if(imagen == "")
		{
			$("#pImagenF").hide();
		}
		else
		{
			$("#contenidoPistaF").addClass("conImagen");
			var rutaImagen = rutaRecursos+imagen;
			var imagenCadena = "<img id='pistaImagenF' src='"+rutaImagen+"' width='40px' height='40px'></a>";
			$("#pImagenF").html(imagenCadena);
		}
	}		

	function getDatosRespuestas(s) {
		var datos = {};
		datos['m'] = {};
		datos['m']['s'] = s;
		datos['r'] = respuestasSecuencia;
		return datos;
	}

	function actualizaPuntosFinal(tipoAlerta) {
		if (tipoAlerta == "tiempo") {
            puntosReg = 0;
        }
	}