var elements = [
  {color: "blue", label: 'blue', textColor: 'white', initialNumber: 6},
  {color: "red", label: 'red', initialNumber: 7},
  {color: "gray", label: 'gray', initialNumber: 8},
  {color: "lime", label: 'lime', initialNumber: 9},
  {color: "pink", label: 'pink', initialNumber: 0},
  {color: "yellow", label: 'yellow', initialNumber: 1},
  {color: "purple", label: 'purple', initialNumber: 0},
  {color: "brown", label: 'brown', initialNumber: 1},
  {color: "cyan", label: 'cyan', initialNumber: 2},
  {color: "orange", label: 'orange', initialNumber: 3},
  {color: "black", label: 'black', textColor: 'white', initialNumber: 4},
  {color: "green", label: 'green', textColor: 'white', initialNumber: 5}
]
var slices = elements.length;
var sliceDeg = 360/slices;
var initialDeg = -(sliceDeg/2)-slices/4*sliceDeg;
var currentDeg = initialDeg;
var initialSpeed = 0;
var maxSpeed = 3;
var ctx;
var width;
var height;
var canvasWidth;
var canvasHeight;
var wheelWidth;
var center;      // center
var isRotating = false;

var colorFontSize;
var numberFontSize;


function rand(min, max) {
  return Math.random() * (max - min) + min;
}

function deg2rad(deg) {
  return deg * Math.PI/180;
}

function drawSlice(deg,color) {
  ctx.beginPath();
  ctx.fillStyle = color;
  ctx.moveTo(center, center);
  ctx.arc(center, center, wheelWidth/2, deg2rad(deg), deg2rad(deg+sliceDeg));
  ctx.lineWidth = 5;
  ctx.stroke();
  ctx.lineTo(center, center);
  ctx.fill();
}

function drawText(deg, text, color) {
  ctx.save();

  let h = wheelWidth/2*0.8;
  ctx.translate(center + h * Math.cos(deg2rad(deg)) + textX, center + h*Math.sin(deg2rad(deg) + textY));
  
  ctx.rotate(deg2rad(0));
  ctx.textAlign = "center";
  if(typeof color === "undefined"){
    color = "black";
  }
  ctx.fillStyle = color;
  ctx.font = 'bold ' + colorFontSize + 'px sans-serif';
  ctx.fillText(text, 130, 10);
  ctx.restore();
}

function drawNumber(deg, text, color) {
  ctx.save();
  let h = (canvasWidth/2)*0.9;
  ctx.translate(center + h * Math.cos(deg2rad(deg+sliceDeg/2)) + numberX, center + h*Math.sin(deg2rad(deg+sliceDeg/2)) + numberY);
  
  ctx.rotate(deg2rad(0));
  ctx.textAlign = "center";
  if(typeof color === "undefined"){
    color = "black";
  }
  ctx.fillStyle = color;
  ctx.font = 'bold ' + numberFontSize + 'px sans-serif';
  ctx.fillText(text, 130, 10);
  ctx.restore();
}

function drawImg() {
  ctx.clearRect(0, 0, canvasWidth, canvasWidth);
  var deg = currentDeg;
  for(var i=0; i<slices; i++){
    drawSlice(deg, elements[i].color);
    deg += sliceDeg;
  }
  deg = currentDeg;
  for(var i=0; i<slices; i++){
    drawText(deg+sliceDeg/2, elements[i].label, elements[i].textColor);
    deg += sliceDeg;
  }
  currentDeg = (deg)%360;
  drawNumbers();
}

function drawNumbers() {
  var deg = initialDeg;
  for(var i=0; i<slices; i++){
    drawNumber(deg, elements[i].initialNumber);
    deg += sliceDeg;
  }
}

function rotateClockwise(){
  rotateWheel(sliceDeg);
}

function rotateCounterclockwise(){
  rotateWheel(-sliceDeg);
}

function rotateWheel(deg){
  if((deg===0)||(isRotating)){
    return;
  }
  isRotating = true;

  var finalDeg = (currentDeg+deg);
  var time = 700 * (Math.abs(deg)/sliceDeg); //ms
  var fps = 50;
  var totalFrames = fps*time/1000;
  var renderedFrames = 0;
  var degsPerFrame = (Math.abs(finalDeg-currentDeg))/totalFrames;

  var rotateTimer = setInterval(function(){
    if(currentDeg > finalDeg){
      currentDeg -= degsPerFrame;
    } else {
      currentDeg += degsPerFrame;
    }
    renderedFrames++;
    if(renderedFrames === totalFrames){
      currentDeg = finalDeg;
      clearTimeout(rotateTimer);
      isRotating = false;
    }
    drawImg();
  },(1000/fps));
}

function init(){
  var canvas = document.getElementById('canvas');
  ctx = canvas.getContext('2d');
  width = window.innerWidth;
  height = window.innerHeight;

  if(width > height){
    canvasWidth = height;
    canvasHeight = height;
  } else {
    canvasWidth = width;
    canvasHeight = width;
  }

  ctx.canvas.width  = canvasWidth;
  ctx.canvas.height = canvasHeight;

  wheelWidth = canvasWidth*0.8; //wheel size
  center = canvasWidth/2;      // wheel center
  
  // console.log(canvasWidth)
  // console.log(canvasHeight)
  if(canvasWidth >= 700){
    colorFontSize = 25;
    numberFontSize = 49;
    textX = -125;
    textY = 0;
    numberX = - 135;
    numberY = 10;
  } else if(canvasWidth >= 500){
    colorFontSize = 20;
    numberFontSize = 30;
    textX = -125;
    textY = 0;
    numberX = - 135;
    numberY = 3;
  } else {
    colorFontSize = 13;
    numberFontSize = 18;
    textX = -128;
    textY = 0;
    numberX = -132;
    numberY = -2;
  }

  // canvas.addEventListener('click', (e) => {
  //   rotateClockwise();
  // });

  var zt = new ZingTouch.Region(document.body);
  var ztPan = new ZingTouch.Pan({
    numInputs: 1
  })
  var ztAccuracy = 40;
  
  zt.bind(canvas, ztPan, function(event){
    if(isRotating){
      event.stopPropagation();
      event.preventDefault();
      return false;
    }

    var eventData = event.detail.data[0];
    var x = event.detail.events[0].x;
    var y = event.detail.events[0].y;
    var direction = eventData.directionFromOrigin;
    var distance = eventData.distanceFromOrigin;

    // console.log("x:"+x);
    // console.log("y:"+y);
    // console.log("direction:"+direction);

    if(distance < 20){
      return false;
    }

    if((Math.abs(360-direction)<ztAccuracy)||Math.abs(0-direction)<ztAccuracy){
      //Swipe from left to right
      if(y <= height/2){
        rotateClockwise();
      } else {
        rotateCounterclockwise();
      }
    } else if(Math.abs(180-direction)<ztAccuracy){
      //Swipe from right to left
      if(y > height/2){
        rotateClockwise();
      } else {
        rotateCounterclockwise();
      }
    } else if(Math.abs(90-direction)<ztAccuracy){
      //Swipe from bottom to top
      if(x <= width/2){
        rotateClockwise();
      } else {
        rotateCounterclockwise();
      }
    } else if(Math.abs(270-direction)<ztAccuracy){
      //Swipe from top to bottom
      if(x > width/2){
        rotateClockwise();
      } else {
        rotateCounterclockwise();
      }
    }

  });

  zt.bind(canvas, 'tap', function(e){
    rotateClockwise();
  }, false);

  drawImg();
}