var CODEditor = CODEditor || {};
CODEditor.Viewer = true;
CODEditor.File = {"type":"test","title":"HTML exercises","exercises":"[{\"type\":\"exercise\",\"title\":\"HTML basic page structure\",\"description\":\"Below you can find an empty html page called index.html. \\nFill in it with the basic HTML tags, containing at least <code>html5 doctype, html, body and head</code>. Give the id <b>main</b> to the body.\\nPressing the button <b>Run code (play)</b> on the top right corner, you will be able to see the HTML page and the test result.\\nPressing the title <b>HTML exercises</b> or the selector beside it you can access the different exercises of this autoevaluation test.\",\"editorMode\":\"HTML\",\"content\":\"\",\"progress\":{\"score\":0,\"passed\":false},\"score_function\":\"var score = function(document){\\n  var grade = {};\\n  grade.successes = [];\\n  grade.errors = [];\\n  grade.feedback = [];\\n  grade.score = 0;\\n\\n  if (document.doctype === undefined || document.doctype === null) {\\n\\t  \\tgrade.errors.push(\\\"You did not add the doctype declaration.\\\");\\n\\t} else if(document.doctype.publicId !== ''){\\n     \\tgrade.errors.push(\\\"You did not add the HTML5 doctype declaration.\\\");\\n  } else{\\n      grade.score +=5;\\n\\t    grade.successes.push(\\\"You added the doctype declaration\\\");\\n  }\\n\\n  if($(document).find(\\\"#main\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"You did not add the <body> element with an id 'main'.\\\");\\n\\t} else {\\n\\t  grade.score +=5;\\n\\t  grade.successes.push(\\\"You added the <body> element\\\");\\n\\t}\\n\\n  return grade;\\n};\\n\"},{\"type\":\"exercise\",\"title\":\"My first HTML page\",\"description\":\"The next page contains the basic HTML page structure. As you can see it contains the main tags: <code><html> <head> and <body></code>.\\nStudy how these tags contain one another and add the following inside the body:\\n- An h1 element with the id attribute \\\"title\\\" and the content \\\"My first HTML page\\\"\\n- A paragraph (<code><p></code>) element with the class <b>\\\"myp\\\"</b> and the content a first text of your choice\\n- In the content of the paragraph with class <b>\\\"myp\\\"</b> add a <code><span></code> with class <b>red</b>\\n- An image below the paragraph using an <code><img></code> tag, with id \\\"myimg\\\", attributes width and height 300px, and for the src use an absolute URL of your choice.\",\"content\":\"<!DOCTYPE html>\\n<html>\\n  <head>\\n  </head>\\n  <body>\\n    \\n  </body>\\n</html>\\n\",\"editorMode\":\"HTML\",\"progress\":{\"score\":0,\"passed\":false},\"score_function\":\"var score = function(document){\\n  var grade = {};\\n  grade.successes = [];\\n  grade.errors = [];\\n  grade.feedback = [];\\n  grade.score = 0;\\n\\n\\tif($(document).find(\\\"h1\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"You did not add the <h1> element\\\");\\n\\t} else {\\n\\t  grade.score +=1;\\n\\t  grade.successes.push(\\\"You added the <h1> element\\\");\\n\\t}\\n\\tif($(document).find(\\\"body h1\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"The <h1> element should be inside <body>.\\\");\\n\\t} else {\\n\\t  grade.score +=1;\\n\\t  grade.successes.push(\\\"The <h1> element is inside the body element\\\");\\n\\t}\\n\\tif($(document).find(\\\"body h1#title\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"The <h1> element should have id 'title'.\\\");\\n\\t} else {\\n\\t  grade.score +=1;\\n\\t  grade.successes.push(\\\"The <h1> element has id 'title'.\\\");\\n\\t}\\n\\tif($(document).find(\\\"body h1#title\\\").text().trim() !== 'My first HTML page'){\\n\\t  \\tgrade.errors.push(\\\"The <h1> element should have the content 'My first HTML page'\\\");\\n\\t} else {\\n\\t  grade.score +=1;\\n\\t  grade.successes.push(\\\"The <h1> element has the content 'My first HTML page'\\\");\\n\\t}\\n\\tif($(document).find(\\\"body p\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"The page should have a p element inside body\\\");\\n\\t} else {\\n\\t  grade.score +=1;\\n\\t  grade.successes.push(\\\"The page has a p element inside body\\\");\\n\\t}\\n\\tif($(document).find(\\\"body p.myp\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"The p element should have class myp\\\");\\n\\t} else {\\n\\t  grade.score +=1;\\n\\t  grade.successes.push(\\\"The p element has class myp\\\");\\n\\t}\\n\\tif($(document).find(\\\"body p span\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"The page should have a span inside the paragraph\\\");\\n\\t} else {\\n\\t  grade.score +=1;\\n\\t  grade.successes.push(\\\"The page has a span inside the paragraph\\\");\\n\\t}\\n\\tif($(document).find(\\\"body span.red\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"The span element should have class red\\\");\\n\\t} else {\\n\\t  grade.score +=1;\\n\\t  grade.successes.push(\\\"The span element has class red\\\");\\n\\t}\\n\\tif($(document).find(\\\"body img\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"The page should have an img element with an image of your choice\\\");\\n\\t} else {\\n\\t  grade.score +=1;\\n\\t  grade.successes.push(\\\"The page has an img element with an image of your choice\\\");\\n\\t}\\n\\tif($(document).find(\\\"body img#myimg\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"The page should have an img element with id myimg\\\");\\n\\t} else {\\n\\t  grade.score +=0;\\n\\t  grade.successes.push(\\\"The page has an img element with the right id\\\");\\n\\t}\\n\\tif($(document).find(\\\"body img#myimg\\\").width() !== 300 || $(document).find(\\\"body img#myimg\\\").height() !==300){\\n\\t  \\tgrade.errors.push(\\\"The image should have attributes width and height with value 300px\\\");\\n\\t} else {\\n\\t  grade.score +=1;\\n\\t  grade.successes.push(\\\"The image has width and height 300px\\\");\\n\\t}\\n\\n  return grade;\\n};\\n\"},{\"type\":\"exercise\",\"title\":\"More HTML tags\",\"description\":\"There are many HTML tags, in this exercise you find again an empty html page and you have to add the following:\\n- a <code><meta></code> tag indicating that the charset for the page is UTF-8, use the new HTML5 notation for this.\\n- a <code><title></code> tag with content \\\"My second page\\\"\\n- a <code><div></code> with id \\\"wrapper\\\" that will enclose the next elements:\\n- a link to the w3c page (https://www.w3.org/) with id <b>mylink</b> \\n- a unordered list <code><ul></code> with id <b>mylist</b> and this list contains 2 items (<code><li></code>) with text \\\"First item\\\" and \\\"Second item\\\"\",\"editorMode\":\"HTML\",\"content\":\"<!DOCTYPE html>\\n<html>\\n  <head>\\n  </head>\\n  <body>\\n    \\n  </body>\\n</html>\",\"progress\":{\"score\":0,\"passed\":false},\"score_function\":\"var score = function(document){\\n  var grade = {};\\n  grade.successes = [];\\n  grade.errors = [];\\n  grade.feedback = [];\\n  grade.score = 0;\\n\\n\\n  if(document===\\\"\\\"){\\n    return grade;\\n  }\\n\\n  if(!document.querySelector('meta[charset]') || !document.querySelector('meta[charset]').outerHTML.includes(\\\"UTF-8\\\")) {\\n    grade.errors.push(\\\"You did not add the <meta> tag indicating the charset\\\");\\n  } else {\\n    grade.score +=1;\\n    grade.successes.push(\\\"You added the <meta> tag\\\");\\n  }\\n\\tif(document.title === \\\"\\\"){\\n\\t  \\tgrade.errors.push(\\\"You did not add the <title> tag\\\");\\n\\t} else {\\n\\t  grade.score +=1;\\n\\t  grade.successes.push(\\\"You added the <title> tag\\\");\\n\\t}\\n\\n\\tif($(document).find(\\\"body div\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"You did not add the a div inside the body\\\");\\n\\t} else {\\n\\t  grade.score +=0;\\n\\t  grade.successes.push(\\\"You did add the a div inside the body\\\");\\n\\t}\\n  if($(document).find(\\\"body div#wrapper\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"You did not add the div with id 'wrapper' inside the body\\\");\\n\\t} else {\\n\\t  grade.score +=1;\\n\\t  grade.successes.push(\\\"You did add the div with id 'wrapper' inside the body\\\");\\n\\t}\\n\\tif($(document).find(\\\"body div#wrapper a\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"You did not add the link inside the div with id 'wrapper'\\\");\\n\\t} else {\\n\\t  grade.score +=0;\\n\\t  grade.successes.push(\\\"You added the link\\\");\\n\\t}\\n  if($(document).find(\\\"body a#mylink\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"The link should have id 'mylink'\\\");\\n\\t} else {\\n\\t  grade.score +=1;\\n\\t  grade.successes.push(\\\"You added the link with the right id\\\");\\n\\t}\\n  if($(document).find(\\\"body div#wrapper a#mylink\\\").length === 0 || !$(document).find(\\\"body a#mylink:first\\\").attr(\\\"href\\\").includes(\\\"w3.org\\\")){\\n\\t  \\tgrade.errors.push(\\\"The link should point to https://www.w3.org/\\\");\\n\\t} else {\\n\\t  grade.score +=1;\\n\\t  grade.successes.push(\\\"The link points to https://www.w3.org/\\\");\\n\\t}\\n  if($(document).find(\\\"body div#wrapper ul\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"You did not add the list inside the div with id 'wrapper'\\\");\\n\\t} else {\\n\\t  grade.score +=1;\\n\\t  grade.successes.push(\\\"You added the list\\\");\\n\\t}\\n  if($(document).find(\\\"body div#wrapper ul#mylist\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"The list should have id 'mylist'\\\");\\n\\t} else {\\n\\t  grade.score +=1;\\n\\t  grade.successes.push(\\\"You added the list with the right id\\\");\\n\\t}\\n  if($(document).find(\\\"body div#wrapper ul#mylist li\\\").length !== 2){\\n\\t  \\tgrade.errors.push(\\\"The list does not cotain two items\\\");\\n\\t} else {\\n\\t  grade.score +=1;\\n\\t  grade.successes.push(\\\"The list contains two items\\\");\\n\\t}\\n  if($(document).find(\\\"body div#wrapper ul#mylist li\\\").length !== 2 || $($(document).find(\\\"body ul#mylist li\\\")[0]).html().trim() !== \\\"First item\\\"){\\n\\t  \\tgrade.errors.push(\\\"The first item of the list should contain 'First item'\\\");\\n\\t} else {\\n\\t  grade.score +=1;\\n\\t  grade.successes.push(\\\"The first item of the list contains 'First item'\\\");\\n\\t}\\n  if($(document).find(\\\"body div#wrapper ul#mylist li\\\").length!==2 || $($(document).find(\\\"body ul#mylist li\\\")[1]).html().trim() !== \\\"Second item\\\"){\\n\\t  \\tgrade.errors.push(\\\"The second item of the list should contain 'Second item'\\\");\\n\\t} else {\\n\\t  grade.score +=1;\\n\\t  grade.successes.push(\\\"The second item of the list contains 'Second item'\\\");\\n\\t}\\n\\n  return grade;\\n};\\n\\n\\n\"},{\"type\":\"exercise\",\"title\":\"HTML5 semantic tags\",\"description\":\"For our MOOC we are creating a blog. We have the following HTML structure, but we want to use the HTML5 semantic tags instead of using divs everywhere.\\nChange the DOM replacing the divs for the HTML5 semantic tags (don't forget to close the tags that you add). See the class of the different elements to have a clue of what semantic tag you should use, don remove the classes of the divs, only change the divs for the new HTML5 semantic tags.\\n\\n\",\"editorMode\":\"HTML\",\"content\":\"<!doctype html>\\n<html>\\n<head>\\n<meta charset=\\\"utf-8\\\">\\n<title>HTML5 structure</title>\\n</head>\\n<body>\\n  <div class=\\\"myheader\\\">\\n    <h1>MOOC blog</h1>\\n  </div>\\n  <div class=\\\"mynavbar\\\">\\n    <ul>\\n      <li><a href=\\\"#\\\">Frontpage</a></li>\\n      <li><a href=\\\"#\\\">Old posts</a></li>\\n      <li><a href=\\\"#\\\">Contact</a></li>\\n    </ul>\\n  </div>\\n  <div class=\\\"allposts\\\">\\n    <div class=\\\"post\\\">\\n      <div class=\\\"mypostheader\\\">\\n        First post of the blog\\n      </div>\\n      <div class=\\\"mypostcontent\\\">\\n        This is the first post of many in this blog!\\n        We are happy to have a blog for our MOOC.\\n      </div>\\n    </div>\\n  </div>\\n  <div class=\\\"mypagefooter\\\">Footer: contact info contact@example.com</div>\\n</body>\\n</html>\",\"progress\":{\"score\":0,\"passed\":false},\"score_function\":\"var score = function(document){\\n  var grade = {};\\n  grade.successes = [];\\n  grade.errors = [];\\n  grade.feedback = [];\\n  grade.score = 0;\\n\\n\\tif($(document).find(\\\"header.myheader\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"You did not change the div with class myheader\\\");\\n\\t} else {\\n\\t  grade.score +=1;\\n\\t  grade.successes.push(\\\"You changed the div with class myheader\\\");\\n\\t}\\n  if($(document).find(\\\"nav.mynavbar\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"You did not change the div with class mynavbar\\\");\\n\\t} else {\\n\\t  grade.score +=1;\\n\\t  grade.successes.push(\\\"You changed the div with class mynavbar\\\");\\n\\t}\\n  if($(document).find(\\\"section.allposts\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"You did not change the div with class allposts\\\");\\n\\t} else {\\n\\t  grade.score +=2;\\n\\t  grade.successes.push(\\\"You changed the div with class allposts\\\");\\n\\t}\\n  if($(document).find(\\\"article.post\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"You did not change the div with class post\\\");\\n\\t} else {\\n\\t  grade.score +=2;\\n\\t  grade.successes.push(\\\"You changed the div with class myheader\\\");\\n\\t}\\n  if($(document).find(\\\"header.mypostheader\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"You did not change the div with class mypostheader\\\");\\n\\t} else {\\n\\t  grade.score +=2;\\n\\t  grade.successes.push(\\\"You changed the div with class mypostheader\\\");\\n\\t}\\n  if($(document).find(\\\"footer.mypagefooter\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"You did not change the div with class mypagefooter\\\");\\n\\t} else {\\n\\t  grade.score +=2;\\n\\t  grade.successes.push(\\\"You changed the div with class mypagefooter\\\");\\n\\t}\\n\\n\\n  return grade;\\n};\"}]","exercisesQuantity":4,"parsed_exercises":[{"type":"exercise","title":"HTML basic page structure","description":"Below you can find an empty html page called index.html. \nFill in it with the basic HTML tags, containing at least <code>html5 doctype, html, body and head</code>. Give the id <b>main</b> to the body.\nPressing the button <b>Run code (play)</b> on the top right corner, you will be able to see the HTML page and the test result.\nPressing the title <b>HTML exercises</b> or the selector beside it you can access the different exercises of this autoevaluation test.","editorMode":"HTML","content":"","progress":{"score":0,"passed":false},"score_function":"var score = function(document){\n  var grade = {};\n  grade.successes = [];\n  grade.errors = [];\n  grade.feedback = [];\n  grade.score = 0;\n\n  if (document.doctype === undefined || document.doctype === null) {\n\t  \tgrade.errors.push(\"You did not add the doctype declaration.\");\n\t} else if(document.doctype.publicId !== ''){\n     \tgrade.errors.push(\"You did not add the HTML5 doctype declaration.\");\n  } else{\n      grade.score +=5;\n\t    grade.successes.push(\"You added the doctype declaration\");\n  }\n\n  if($(document).find(\"#main\").length === 0){\n\t  \tgrade.errors.push(\"You did not add the <body> element with an id 'main'.\");\n\t} else {\n\t  grade.score +=5;\n\t  grade.successes.push(\"You added the <body> element\");\n\t}\n\n  return grade;\n};\n","id":1},{"type":"exercise","title":"My first HTML page","description":"The next page contains the basic HTML page structure. As you can see it contains the main tags: <code><html> <head> and <body></code>.\nStudy how these tags contain one another and add the following inside the body:\n- An h1 element with the id attribute \"title\" and the content \"My first HTML page\"\n- A paragraph (<code><p></code>) element with the class <b>\"myp\"</b> and the content a first text of your choice\n- In the content of the paragraph with class <b>\"myp\"</b> add a <code><span></code> with class <b>red</b>\n- An image below the paragraph using an <code><img></code> tag, with id \"myimg\", attributes width and height 300px, and for the src use an absolute URL of your choice.","content":"<!DOCTYPE html>\n<html>\n  <head>\n  </head>\n  <body>\n    \n  </body>\n</html>\n","editorMode":"HTML","progress":{"score":0,"passed":false},"score_function":"var score = function(document){\n  var grade = {};\n  grade.successes = [];\n  grade.errors = [];\n  grade.feedback = [];\n  grade.score = 0;\n\n\tif($(document).find(\"h1\").length === 0){\n\t  \tgrade.errors.push(\"You did not add the <h1> element\");\n\t} else {\n\t  grade.score +=1;\n\t  grade.successes.push(\"You added the <h1> element\");\n\t}\n\tif($(document).find(\"body h1\").length === 0){\n\t  \tgrade.errors.push(\"The <h1> element should be inside <body>.\");\n\t} else {\n\t  grade.score +=1;\n\t  grade.successes.push(\"The <h1> element is inside the body element\");\n\t}\n\tif($(document).find(\"body h1#title\").length === 0){\n\t  \tgrade.errors.push(\"The <h1> element should have id 'title'.\");\n\t} else {\n\t  grade.score +=1;\n\t  grade.successes.push(\"The <h1> element has id 'title'.\");\n\t}\n\tif($(document).find(\"body h1#title\").text().trim() !== 'My first HTML page'){\n\t  \tgrade.errors.push(\"The <h1> element should have the content 'My first HTML page'\");\n\t} else {\n\t  grade.score +=1;\n\t  grade.successes.push(\"The <h1> element has the content 'My first HTML page'\");\n\t}\n\tif($(document).find(\"body p\").length === 0){\n\t  \tgrade.errors.push(\"The page should have a p element inside body\");\n\t} else {\n\t  grade.score +=1;\n\t  grade.successes.push(\"The page has a p element inside body\");\n\t}\n\tif($(document).find(\"body p.myp\").length === 0){\n\t  \tgrade.errors.push(\"The p element should have class myp\");\n\t} else {\n\t  grade.score +=1;\n\t  grade.successes.push(\"The p element has class myp\");\n\t}\n\tif($(document).find(\"body p span\").length === 0){\n\t  \tgrade.errors.push(\"The page should have a span inside the paragraph\");\n\t} else {\n\t  grade.score +=1;\n\t  grade.successes.push(\"The page has a span inside the paragraph\");\n\t}\n\tif($(document).find(\"body span.red\").length === 0){\n\t  \tgrade.errors.push(\"The span element should have class red\");\n\t} else {\n\t  grade.score +=1;\n\t  grade.successes.push(\"The span element has class red\");\n\t}\n\tif($(document).find(\"body img\").length === 0){\n\t  \tgrade.errors.push(\"The page should have an img element with an image of your choice\");\n\t} else {\n\t  grade.score +=1;\n\t  grade.successes.push(\"The page has an img element with an image of your choice\");\n\t}\n\tif($(document).find(\"body img#myimg\").length === 0){\n\t  \tgrade.errors.push(\"The page should have an img element with id myimg\");\n\t} else {\n\t  grade.score +=0;\n\t  grade.successes.push(\"The page has an img element with the right id\");\n\t}\n\tif($(document).find(\"body img#myimg\").width() !== 300 || $(document).find(\"body img#myimg\").height() !==300){\n\t  \tgrade.errors.push(\"The image should have attributes width and height with value 300px\");\n\t} else {\n\t  grade.score +=1;\n\t  grade.successes.push(\"The image has width and height 300px\");\n\t}\n\n  return grade;\n};\n","id":2},{"type":"exercise","title":"More HTML tags","description":"There are many HTML tags, in this exercise you find again an empty html page and you have to add the following:\n- a <code><meta></code> tag indicating that the charset for the page is UTF-8, use the new HTML5 notation for this.\n- a <code><title></code> tag with content \"My second page\"\n- a <code><div></code> with id \"wrapper\" that will enclose the next elements:\n- a link to the w3c page (https://www.w3.org/) with id <b>mylink</b> \n- a unordered list <code><ul></code> with id <b>mylist</b> and this list contains 2 items (<code><li></code>) with text \"First item\" and \"Second item\"","editorMode":"HTML","content":"<!DOCTYPE html>\n<html>\n  <head>\n  </head>\n  <body>\n    \n  </body>\n</html>","progress":{"score":0,"passed":false},"score_function":"var score = function(document){\n  var grade = {};\n  grade.successes = [];\n  grade.errors = [];\n  grade.feedback = [];\n  grade.score = 0;\n\n\n  if(document===\"\"){\n    return grade;\n  }\n\n  if(!document.querySelector('meta[charset]') || !document.querySelector('meta[charset]').outerHTML.includes(\"UTF-8\")) {\n    grade.errors.push(\"You did not add the <meta> tag indicating the charset\");\n  } else {\n    grade.score +=1;\n    grade.successes.push(\"You added the <meta> tag\");\n  }\n\tif(document.title === \"\"){\n\t  \tgrade.errors.push(\"You did not add the <title> tag\");\n\t} else {\n\t  grade.score +=1;\n\t  grade.successes.push(\"You added the <title> tag\");\n\t}\n\n\tif($(document).find(\"body div\").length === 0){\n\t  \tgrade.errors.push(\"You did not add the a div inside the body\");\n\t} else {\n\t  grade.score +=0;\n\t  grade.successes.push(\"You did add the a div inside the body\");\n\t}\n  if($(document).find(\"body div#wrapper\").length === 0){\n\t  \tgrade.errors.push(\"You did not add the div with id 'wrapper' inside the body\");\n\t} else {\n\t  grade.score +=1;\n\t  grade.successes.push(\"You did add the div with id 'wrapper' inside the body\");\n\t}\n\tif($(document).find(\"body div#wrapper a\").length === 0){\n\t  \tgrade.errors.push(\"You did not add the link inside the div with id 'wrapper'\");\n\t} else {\n\t  grade.score +=0;\n\t  grade.successes.push(\"You added the link\");\n\t}\n  if($(document).find(\"body a#mylink\").length === 0){\n\t  \tgrade.errors.push(\"The link should have id 'mylink'\");\n\t} else {\n\t  grade.score +=1;\n\t  grade.successes.push(\"You added the link with the right id\");\n\t}\n  if($(document).find(\"body div#wrapper a#mylink\").length === 0 || !$(document).find(\"body a#mylink:first\").attr(\"href\").includes(\"w3.org\")){\n\t  \tgrade.errors.push(\"The link should point to https://www.w3.org/\");\n\t} else {\n\t  grade.score +=1;\n\t  grade.successes.push(\"The link points to https://www.w3.org/\");\n\t}\n  if($(document).find(\"body div#wrapper ul\").length === 0){\n\t  \tgrade.errors.push(\"You did not add the list inside the div with id 'wrapper'\");\n\t} else {\n\t  grade.score +=1;\n\t  grade.successes.push(\"You added the list\");\n\t}\n  if($(document).find(\"body div#wrapper ul#mylist\").length === 0){\n\t  \tgrade.errors.push(\"The list should have id 'mylist'\");\n\t} else {\n\t  grade.score +=1;\n\t  grade.successes.push(\"You added the list with the right id\");\n\t}\n  if($(document).find(\"body div#wrapper ul#mylist li\").length !== 2){\n\t  \tgrade.errors.push(\"The list does not cotain two items\");\n\t} else {\n\t  grade.score +=1;\n\t  grade.successes.push(\"The list contains two items\");\n\t}\n  if($(document).find(\"body div#wrapper ul#mylist li\").length !== 2 || $($(document).find(\"body ul#mylist li\")[0]).html().trim() !== \"First item\"){\n\t  \tgrade.errors.push(\"The first item of the list should contain 'First item'\");\n\t} else {\n\t  grade.score +=1;\n\t  grade.successes.push(\"The first item of the list contains 'First item'\");\n\t}\n  if($(document).find(\"body div#wrapper ul#mylist li\").length!==2 || $($(document).find(\"body ul#mylist li\")[1]).html().trim() !== \"Second item\"){\n\t  \tgrade.errors.push(\"The second item of the list should contain 'Second item'\");\n\t} else {\n\t  grade.score +=1;\n\t  grade.successes.push(\"The second item of the list contains 'Second item'\");\n\t}\n\n  return grade;\n};\n\n\n","id":3},{"type":"exercise","title":"HTML5 semantic tags","description":"For our MOOC we are creating a blog. We have the following HTML structure, but we want to use the HTML5 semantic tags instead of using divs everywhere.\nChange the DOM replacing the divs for the HTML5 semantic tags (don't forget to close the tags that you add). See the class of the different elements to have a clue of what semantic tag you should use, don remove the classes of the divs, only change the divs for the new HTML5 semantic tags.\n\n","editorMode":"HTML","content":"<!doctype html>\n<html>\n<head>\n<meta charset=\"utf-8\">\n<title>HTML5 structure</title>\n</head>\n<body>\n  <div class=\"myheader\">\n    <h1>MOOC blog</h1>\n  </div>\n  <div class=\"mynavbar\">\n    <ul>\n      <li><a href=\"#\">Frontpage</a></li>\n      <li><a href=\"#\">Old posts</a></li>\n      <li><a href=\"#\">Contact</a></li>\n    </ul>\n  </div>\n  <div class=\"allposts\">\n    <div class=\"post\">\n      <div class=\"mypostheader\">\n        First post of the blog\n      </div>\n      <div class=\"mypostcontent\">\n        This is the first post of many in this blog!\n        We are happy to have a blog for our MOOC.\n      </div>\n    </div>\n  </div>\n  <div class=\"mypagefooter\">Footer: contact info contact@example.com</div>\n</body>\n</html>","progress":{"score":0,"passed":false},"score_function":"var score = function(document){\n  var grade = {};\n  grade.successes = [];\n  grade.errors = [];\n  grade.feedback = [];\n  grade.score = 0;\n\n\tif($(document).find(\"header.myheader\").length === 0){\n\t  \tgrade.errors.push(\"You did not change the div with class myheader\");\n\t} else {\n\t  grade.score +=1;\n\t  grade.successes.push(\"You changed the div with class myheader\");\n\t}\n  if($(document).find(\"nav.mynavbar\").length === 0){\n\t  \tgrade.errors.push(\"You did not change the div with class mynavbar\");\n\t} else {\n\t  grade.score +=1;\n\t  grade.successes.push(\"You changed the div with class mynavbar\");\n\t}\n  if($(document).find(\"section.allposts\").length === 0){\n\t  \tgrade.errors.push(\"You did not change the div with class allposts\");\n\t} else {\n\t  grade.score +=2;\n\t  grade.successes.push(\"You changed the div with class allposts\");\n\t}\n  if($(document).find(\"article.post\").length === 0){\n\t  \tgrade.errors.push(\"You did not change the div with class post\");\n\t} else {\n\t  grade.score +=2;\n\t  grade.successes.push(\"You changed the div with class myheader\");\n\t}\n  if($(document).find(\"header.mypostheader\").length === 0){\n\t  \tgrade.errors.push(\"You did not change the div with class mypostheader\");\n\t} else {\n\t  grade.score +=2;\n\t  grade.successes.push(\"You changed the div with class mypostheader\");\n\t}\n  if($(document).find(\"footer.mypagefooter\").length === 0){\n\t  \tgrade.errors.push(\"You did not change the div with class mypagefooter\");\n\t} else {\n\t  grade.score +=2;\n\t  grade.successes.push(\"You changed the div with class mypagefooter\");\n\t}\n\n\n  return grade;\n};","id":4}],"metadata":{"title":"HTML exercises","language":"es"}}