var CODEditor = CODEditor || {};
CODEditor.Viewer = true;
CODEditor.File = {"type":"exercise","title":"Area of an ellipse","description":"Return in the <b>'ellipse'</b> variable a function that calculates the area of an ellipse according to the equation <code>area = &#928;·a·b</code> formula, being a and b the radius of the semi-axis of the ellipse. The function can be invoked in two different ways:\n  (a) by means of two numerical parameters' <b>a</b>' and' <b>b</b>'.\n  (b) by a single array-type parameter containing the values of a and b.\nIf the function receives an object other than an array as a parameter, it will return <b>-1</b>.\nIf the function receives as parameter an array that does not contain the appropriate values, it will return <b>-2</b>.\nIn any other case in which the function receives erroneous parameters, it must return the <b>-3</b> value.\nIf the parameters are correct, the function will return the value of the ellipse area.","editorMode":"JavaScript","content":"/*\n * Return in the variable' ellipse' a function that calculates the area of an ellipse according to the formula 'area = Π·a·b'\n */\n\nvar ellipse = function(a,b){\n\n};\n","score_function":"var score = function (result,variablesHash){\r\n\t\tvar grade = {};\r\n\t\tgrade.successes = [];\r\n\t\tgrade.errors = [];\r\n\t\tgrade.feedback = [];\r\n\t\tgrade.score = 0;\r\n\r\n\t\tvar ellipse = variablesHash[\"ellipse\"];\r\n\r\n\t\tif(typeof ellipse !== \"function\"){\r\n\t\t\tgrade.errors.push(\"The value returned in the variable 'ellipse' is not a function.\");\r\n\t\t\treturn grade;\r\n\t\t}\r\n\r\n\t\t//Testear la función.\r\n\r\n\t\tvar _feedbackPI = false;\r\n\r\n\t\t//Case: a,b numbers\r\n\t\ttry {\r\n\t\t\tvar testA = ellipse(0,0);\r\n\t\t\tvar testB = ellipse(1,1);\r\n\t\t\tvar testC = ellipse(2,5);\r\n\t\t\tif((testA===0)&&(testB===Math.PI)&&(testC===10*Math.PI)){\r\n\t\t\t\tgrade.score += 2;\r\n\t\t\t\tgrade.successes.push(\"The 'ellipse' function works correctly when 'a' and 'b' are numbers.\");\r\n\t\t\t} else {\r\n\t\t\t\tgrade.errors.push(\"The ellipse function does not correctly calculate the expected value when 'a' and 'b' are numbers.\");\r\n\t\t\t\tif(Math.abs(testB-Math.PI) < 0.1){\r\n\t\t\t\t\tgrade.score += 1;\r\n\t\t\t\t\tgrade.feedback.push(\"Some calculated values are quite close to the expected one without being exact. Remember that the PI value can be obtained by using the JavaScript Math module in the following way:\\\"Math.PI\\\"\");\r\n\t\t\t\t\t_feedbackPI = true;\r\n\t\t\t\t}\r\n\t\t\t}\r\n\t\t} catch (e1){\r\n\t\t\tgrade.errors.push(\"The 'ellipse' function presents execution errors when 'a' and 'b' are numbers.\");\r\n\t\t}\r\n\r\n\t\tif(grade.errors.length > 0){\r\n\t\t\treturn grade;\r\n\t\t}\r\n\r\n\t\t//Case: a, array\r\n\t\ttry {\r\n\t\t\tvar testD = ellipse([0,0]);\r\n\t\t\tvar testE = ellipse([1,1]);\r\n\t\t\tvar testF = ellipse([2,5]);\r\n\t\t\tif((testD===0)&&(testE===Math.PI)&&(testF===10*Math.PI)){\r\n\t\t\t\tgrade.score += 2;\r\n\t\t\t\tgrade.successes.push(\"The 'ellipse' function works correctly when 'a' is an array.\");\r\n\t\t\t} else {\r\n\t\t\t\tgrade.errors.push(\"The 'ellipse' function does not correctly calculate the expected value when 'a' is an array.\");\r\n\t\t\t\tif(Math.abs(testE-Math.PI) < 0.1){\r\n\t\t\t\t\tgrade.score += 1;\r\n\t\t\t\t\tif(!_feedbackPI){\r\n\t\t\t\t\t\tgrade.feedback.push(\"Some calculated values are quite close to the expected one without being exact. Remember that the PI value can be obtained by using the JavaScript Math module in the following way:'Math. PI'.\");\r\n\t\t\t\t\t\t_feedbackPI= true;\r\n\t\t\t\t\t}\r\n\t\t\t\t}\r\n\t\t\t}\r\n\t\t} catch (e2){\r\n\t\t\tgrade.errors.push(\"The 'ellipse' function presents execution errors when 'a' is an array.\");\r\n\t\t}\r\n\r\n\t\tif(grade.errors.length > 0){\r\n\t\t\treturn grade;\r\n\t\t}\r\n\r\n\r\n\t\t//Si la función recibe como parámetro un objeto que no sea un array devolverá -1.\r\n\t\ttry {\r\n\t\t\tif((ellipse({})===-1)&&(ellipse(new Date())===-1)){\r\n\t\t\t\tgrade.score += 2;\r\n\t\t\t\tgrade.successes.push(\"The 'ellipse' function works correctly when 'a' is a different object from an array.\");\r\n\t\t\t} else {\r\n\t\t\t\tgrade.errors.push(\"The 'ellipse' function does not work properly when 'a' is an object other than an array.\");\r\n\t\t\t}\r\n\t\t} catch (e2){\r\n\t\t\tgrade.errors.push(\"The 'ellipse' function presents execution errors when 'a' is a different object from an array.\");\r\n\t\t}\r\n\r\n\t\t//Si la función recibe como parámetro un array que no contenga los valores adecuados devolverá -2.\r\n\t\ttry {\r\n\t\t\tif((ellipse([])===-2)&&(ellipse([5,\"test\"])===-2)&&(ellipse([undefined,5])===-2)){\r\n\t\t\t\tgrade.score += 1;\r\n\t\t\t\tgrade.successes.push(\"The 'ellipse' function works correctly when 'a' is an invalid array.\");\r\n\t\t\t} else {\r\n\t\t\t\tgrade.errors.push(\"The 'ellipse' function does not work properly when 'a' is an invalid array.\");\r\n\t\t\t}\r\n\r\n\t\t\tif(ellipse([-1,-1])===-2){\r\n\t\t\t\tgrade.score += 1;\r\n\t\t\t} else {\r\n\t\t\t\tgrade.feedback.push(\"An array containing negative numbers is also considered an invalid array.\");\r\n\t\t\t}\r\n\r\n\t\t} catch (e2){\r\n\t\t\tgrade.errors.push(\"The 'ellipse' function presents execution errors when 'a' is an invalid array.\");\r\n\t\t}\r\n\r\n\t\t// En cualquier otro caso en que la función reciba parámetros erroneos deberá devolver el valor -3.\r\n\t\ttry {\r\n\t\t\tif((ellipse()===-3)&&(ellipse(5)===-3)&&(ellipse(5,null)===-3)&&(ellipse(undefined,5)===-3)&&(ellipse(\"perro\",10)===-3)){\r\n\t\t\t\tgrade.score += 1;\r\n\t\t\t\tgrade.successes.push(\"The ellipse function works correctly when it receives invalid parameters.\");\r\n\t\t\t} else {\r\n\t\t\t\tgrade.errors.push(\"The ellipse function does not work properly when it receives invalid parameters.\");\r\n\t\t\t}\r\n\r\n\t\t\tif(ellipse(-1,-1)===-3){\r\n\t\t\t\tgrade.score += 1;\r\n\t\t\t} else {\r\n\t\t\t\tgrade.feedback.push(\"Values a and b should always be positive. Otherwise, invalid parameters should be considered.\");\r\n\t\t\t}\r\n\r\n\t\t} catch (e2){\r\n\t\t\tgrade.errors.push(\"The ellipse function has execution errors when it receives invalid parameters.\");\r\n\t\t}\r\n\r\n\t\t//Scale grade\r\n\t\tgrade.score = Math.min(10,Math.max(0,grade.score));\r\n\r\n\t\t//Passed threshold: 8\r\n\t\tif(grade.score < 8){\r\n\t\t\tgrade.score = 4;\r\n\t\t}\r\n\r\n\t\tif(grade.score===10){\r\n\t\t\tgrade.feedback.push(\"Congratulations, your solution is perfect!\");\r\n\t\t}\r\n\r\n\t\treturn grade;\r\n\t}","score_function_vars":["ellipse"],"metadata":{"title":"Area of an ellipse","language":"es"}}