var CODEditor = CODEditor || {};
CODEditor.Viewer = true;
CODEditor.File = {"type":"exercise","title":"Área de una elipse","description":"Devuelva en la variable <b>'elipse'</b> una función que calcule el área de una elipse de acuerdo a la fórmula <code>Área = &#928;·a·b</code>, siendo a y b el radio de los semiejes de la elipse. La función podrá ser invocada de dos formas diferentes:\n  a) mediante dos parámetros numéricos '<b>a</b>' y '<b>b</b>'.\n  b) mediante un solo parámetro de tipo array que contenga los valores de a y b.\n-&gt; Si la función recibe como parámetro un objeto que no sea un array devolverá <b>-1</b>.\n-&gt; Si la función recibe como parámetro un array que no contenga los valores adecuados devolverá <b>-2</b>.\n-&gt; En cualquier otro caso en que la función reciba parámetros erroneos deberá devolver el valor <b>-3</b>.\n-&gt; Si los parámetros son correctos, la función devolverá el valor del área de la elipse.\n","editorMode":"JavaScript","content":"/*\n * Devuelva en la variable 'elipse' una función que calcule el área de una elipse de acuerdo a la fórmula 'Área = Π·a·b'\n */\n\nvar elipse = function(a,b){\n\n};\n","score_function":"var score = function (result,variablesHash){\n\t\tvar grade = {};\n\t\tgrade.successes = [];\n\t\tgrade.errors = [];\n\t\tgrade.feedback = [];\n\t\tgrade.score = 0;\n\n\t\tvar elipse = variablesHash[\"elipse\"];\n\n\t\tif(typeof elipse !== \"function\"){\n\t\t\tgrade.errors.push(\"El valor devuelto en la variable 'elipse' no es una función.\");\n\t\t\treturn grade;\n\t\t}\n\t\tgrade.score += 1;\n\n\t\t//Testear la función.\n\n\t\tvar _feedbackPI = false;\n\n\t\t//Case: a,b numbers\n\t\ttry {\n\t\t\tvar testA = elipse(0,0);\n\t\t\tvar testB = elipse(1,1);\n\t\t\tvar testC = elipse(2,5);\n\t\t\tif((testA===0)&&(testB===Math.PI)&&(testC===10*Math.PI)){\n\t\t\t\tgrade.score += 2;\n\t\t\t\tgrade.successes.push(\"La función 'elipse' funciona correctamente cuando 'a' y 'b' son números.\");\n\t\t\t} else {\n\t\t\t\tgrade.errors.push(\"La función 'elipse' no calcula correctamente el valor esperado cuando 'a' y 'b' son números.\");\n\t\t\t\tif(Math.abs(testB-Math.PI) < 0.1){\n\t\t\t\t\tgrade.score += 1;\n\t\t\t\t\tgrade.feedback.push(\"Algunos valores calculados se acercan bastante al esperado sin llegar a ser exactos. Recuerda que el valor de PI puede ser obtenido empleando el módulo Math de JavaScript de la siguiente forma \\\"Math.PI\\\".\");\n\t\t\t\t\t_feedbackPI = true;\n\t\t\t\t}\n\t\t\t}\n\t\t} catch (e1){\n\t\t\tgrade.errors.push(\"La función 'elipse' presenta errores de ejecución cuando 'a' y 'b' son números.\");\n\t\t}\n\n\t\tif(grade.errors.length > 0){\n\t\t\treturn grade;\n\t\t}\n\n\t\t//Case: a, array\n\t\ttry {\n\t\t\tvar testD = elipse([0,0]);\n\t\t\tvar testE = elipse([1,1]);\n\t\t\tvar testF = elipse([2,5]);\n\t\t\tif((testD===0)&&(testE===Math.PI)&&(testF===10*Math.PI)){\n\t\t\t\tgrade.score += 2;\n\t\t\t\tgrade.successes.push(\"La función 'elipse' funciona correctamente cuando 'a' es un array.\");\n\t\t\t} else {\n\t\t\t\tgrade.errors.push(\"La función 'elipse' no calcula correctamente el valor esperado cuando 'a' es un array.\");\n\t\t\t\tif(Math.abs(testE-Math.PI) < 0.1){\n\t\t\t\t\tgrade.score += 1;\n\t\t\t\t\tif(!_feedbackPI){\n\t\t\t\t\t\tgrade.feedback.push(\"Algunos valores calculados se acercan bastante al esperado sin llegar a ser exactos. Recuerda que el valor de PI puede ser obtenido empleando el módulo Math de JavaScript de la siguiente forma \\\"Math.PI\\\".\");\n\t\t\t\t\t\t_feedbackPI= true;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t} catch (e2){\n\t\t\tgrade.errors.push(\"La función 'elipse' presenta errores de ejecución cuando 'a' es un array.\");\n\t\t}\n\n\t\tif(grade.errors.length > 0){\n\t\t\treturn grade;\n\t\t}\n\n\n\t\t//Si la función recibe como parámetro un objeto que no sea un array devolverá -1.\n\t\ttry {\n\t\t\tif((elipse({})===-1)&&(elipse(new Date())===-1)){\n\t\t\t\tgrade.score += 2;\n\t\t\t\tgrade.successes.push(\"La función 'elipse' funciona correctamente cuando 'a' es un objeto diferente de un array.\");\n\t\t\t} else {\n\t\t\t\tgrade.errors.push(\"La función 'elipse' no funciona correctamente cuando 'a' es un objeto diferente de un array.\");\n\t\t\t}\n\t\t} catch (e2){\n\t\t\tgrade.errors.push(\"La función 'elipse' presenta errores de ejecución cuando 'a' es un objeto diferente de un array.\");\n\t\t}\n\n\t\t//Si la función recibe como parámetro un array que no contenga los valores adecuados devolverá -2.\n\t\ttry {\n\t\t\tif((elipse([])===-2)&&(elipse([5,\"test\"])===-2)&&(elipse([undefined,5])===-2)){\n\t\t\t\tgrade.score += 1;\n\t\t\t\tgrade.successes.push(\"La función 'elipse' funciona correctamente cuando 'a' es un array inválido.\");\n\t\t\t} else {\n\t\t\t\tgrade.errors.push(\"La función 'elipse' no funciona correctamente cuando 'a' es un array inválido.\");\n\t\t\t}\n\n\t\t\tif(elipse([-1,-1])===-2){\n\t\t\t\tgrade.score += 1;\n\t\t\t} else {\n\t\t\t\tgrade.feedback.push(\"Un array que contenga números negativos también se considera un array inválido.\");\n\t\t\t}\n\n\t\t} catch (e2){\n\t\t\tgrade.errors.push(\"La función 'elipse' presenta errores de ejecución cuando 'a' es un array inválido.\");\n\t\t}\n\n\t\t// En cualquier otro caso en que la función reciba parámetros erroneos deberá devolver el valor -3.\n\t\ttry {\n\t\t\tif((elipse()===-3)&&(elipse(5)===-3)&&(elipse(5,null)===-3)&&(elipse(undefined,5)===-3)&&(elipse(\"perro\",10)===-3)){\n\t\t\t\tgrade.score += 1;\n\t\t\t\tgrade.successes.push(\"La función 'elipse' funciona correctamente cuando recibe parámetros inválidos.\");\n\t\t\t} else {\n\t\t\t\tgrade.errors.push(\"La función 'elipse' no funciona correctamente cuando recibe parámetros inválidos.\");\n\t\t\t}\n\n\t\t\tif(elipse(-1,-1)===-3){\n\t\t\t\tgrade.score += 1;\n\t\t\t} else {\n\t\t\t\tgrade.feedback.push(\"Los valores a y b deberían ser siempre positivos. De lo contrario se deberían considerarse parámetros inválidos.\");\n\t\t\t}\n\n\t\t} catch (e2){\n\t\t\tgrade.errors.push(\"La función 'elipse' presenta errores de ejecución cuando recibe parámetros inválidos.\");\n\t\t}\n\n\t\t//Scale grade\n\t\tgrade.score = Math.min(10,Math.max(0,grade.score));\n\n\t\t//Passed threshold: 8\n\t\tif(grade.score < 8){\n\t\t\tgrade.score = 4;\n\t\t}\n\n\t\tif(grade.score===10){\n\t\t\tgrade.feedback.push(\"¡Enhorabuena, tu solución es perfecta!\");\n\t\t}\n\n\t\treturn grade;\n\t}","score_function_vars":["elipse"],"metadata":{"title":"Área de una elipse","language":"es"}}