import React from 'react';
import { Switch, Text, TextInput, View } from 'react-native';

export default class App extends React.Component {
  constructor(props){
    super(props);
    this.state = {switchValue: false};
  }
  _onSwitchValueChange(value){
    this.setState({switchValue: value});
  }
  render() {
    return (
      <View style={{flex:1, alignItems:'stretch'}}>
        <Switch
          value={this.state.switchValue}
          onValueChange={this._onSwitchValueChange.bind(this)}
          style={{alignSelf:'flex-start', margin: 10}} />
        <TextInput 
          editable={this.state.switchValue}
          style={{height:80, padding:10, fontSize:25}} 
          placeholder='Enable the Switch to type' />
      </View>
    )
  }
}