import React from 'react';
import { StatusBar, View } from 'react-native';
import { StackNavigator } from 'react-navigation';

import IndexScreen from './index_screen';
import HelloWorldScreen from './hello_world_screen';

const AppContent = StackNavigator({
  Index: {
    screen: IndexScreen,
    navigationOptions: { header: null }
  },
  HelloWorld: {
    screen: HelloWorldScreen,
    navigationOptions: { header: null }
  }
})

export default class App extends React.Component {
  constructor(props){
    super(props);
    StatusBar.setBackgroundColor("blue",false);
    setTimeout(() => {
      StatusBar.setBackgroundColor("red",true);
    },1500);
  }
  render(){
    return (
      <View style={{flex: 1}}>
        <StatusBar barStyle="light-content" />
        <AppContent />
      </View>
    )
  }
}