import React from 'react';
import { Text, View } from 'react-native';

class MyText extends React.Component {
  constructor(props) {
    super(props);
    this.state = {color: this.props.initialColor};
    setInterval(() => {
      this.setState({color: (this.state.color == 'blue' ? 'black' : 'blue')});
    }, 1000);
  }
  render() {
    return (
      <Text style={{color: this.state.color, fontSize: 30}}>
        {this.props.value}!
      </Text>
    );
  }
}

export default class App extends React.Component {
  render() {
    return (
      <View style={{alignItems: 'center'}}>
        <MyText initialColor='blue' value='Hello World' />
        <MyText initialColor='black' value='Goodbye World' />
      </View>
    );
  }
}