import React from 'react';
import { Text, SectionList } from 'react-native';

export default class App extends React.Component {
  render() {
    var mammals = [{key:'Dog'},{key:'Cat'},{key:'Elephant'},{key:'Monkey'}];
    var birds = [{key:'Eagle'}];
    var reptiles = [{key:'Turtle'}];
    return (
      <SectionList
        sections={[
          {data: mammals, title: 'Mammals'},
          {data: birds, title: 'Birds'},
          {data: reptiles, title: 'Reptiles'}
        ]}
        renderItem={({item}) => <Text style={{fontSize:25}}>{item.key}</Text>}
        renderSectionHeader={({section}) => <Text style={{textAlign:'center', fontSize:35}}>{section.title}</Text>}
      />
    )
  }
}