import React from 'react';
import { TouchableHighlight, Modal, Text, View } from 'react-native';

export default class App extends React.Component {
  constructor(props){
    super(props);
    this.state = {modalVisible:false};
  }
  _setModalVisible(visible){
    this.setState({modalVisible:visible});
  }
  render() {
    return (
      <View style={{flex:1, alignItems:'center', justifyContent:'flex-start'}}>
        <Modal
          animationType="slide"
          transparent={false}
          visible={this.state.modalVisible}
          onRequestClose={() => {alert("User has tapped the back button")}}
        >
          <View style={{padding:30, alignItems:'center', justifyContent:'center'}}>
            <TouchableHighlight style={{alignSelf:'flex-end'}} onPress={() => {this._setModalVisible(false)}}>
              <Text style={{fontSize:20, marginBottom: 20}}>X</Text>
            </TouchableHighlight>
            <Text style={{fontSize:35}}>Hello World!</Text>
          </View>
        </Modal>
        <TouchableHighlight onPress={() => {this._setModalVisible(true)}}>
          <Text style={{fontSize:35}}>Show Modal</Text>
        </TouchableHighlight>
      </View>
    )
  }
}