import React from 'react';
import { Text, TextInput, TouchableHighlight, View, FlatList } from 'react-native';

export default class App extends React.Component {
  constructor(props){
    super(props);
    var movies = [{key:"Star Wars"},{key:"Back to the Future"},{key:"The Matrix"},{key:"Inception"},{key:"Interstellar"}]
    this.state = {movies: movies, valueTextInput: ""}
  }
  _addMovieFromTextInput(){
    if((this.state.valueTextInput.trim() != "")
      &&(this.state.movies.map(function(obj){return obj.key}).indexOf(this.state.valueTextInput)==-1)){
      this._addMovie({key: this.state.valueTextInput});
    }
    this.setState({valueTextInput: ""});
  }
  _addMovie(movie){
    var movies = Object.assign([], this.state.movies);
    movies.push(movie);
    this.setState({movies: movies});
  }
  _removeMovie(movie){
    var movies = Object.assign([], this.state.movies);
    for(let i=0; i<movies.length; i++){
      if(movies[i].key === movie.key){
        movies.splice(i,1);
      }
    }
    this.setState({movies: movies});
  }
  _renderItem({item}){
    return (
      <View style={{flexDirection: 'row'}}>
        <Text style={{fontSize: 30}}>{item.key}</Text>
          <TouchableHighlight onPress={() => this._removeMovie(item)}>
          <Text style={{fontSize:30, color:'red'}}> [X] </Text>
        </TouchableHighlight>
      </View>
    )
  }
  render() {
    return (
      <View style={{flex: 1, padding: 20}}>
        <FlatList
          data={this.state.movies}
          renderItem={this._renderItem.bind(this)}
        />
        <TextInput 
          style={{height: 80, fontSize: 30}} 
          placeholder='Movie title'
          value={this.state.valueTextInput}
          onChangeText={(text) => this.setState({valueTextInput: text})} />
        <TouchableHighlight onPress={this._addMovieFromTextInput.bind(this)}>
          <Text style={{fontSize: 30}}>Add movie</Text>
        </TouchableHighlight>
      </View>
    )
  }
}