import React from 'react';
import { FlatList, Text, View } from 'react-native';

export default class App extends React.Component {
  constructor(props){
    super(props);
    this.state = {movies: []};
  }
  componentDidMount(){
    this.getMoviesFromAPI().then(function(movies){
      if((typeof movies == "object")&&(movies instanceof Array)){
        for(let i=0; i<movies.length; i++){
          movies[i].key = i;
        }
        this.setState({movies: movies});
      }
    }.bind(this)).catch(function(exception){
      alert("Exception: '" + exception + "'");
    });
  }
  async getMoviesFromAPI(){
    var url =  'https://facebook.github.io/react-native/movies.json';
    var response = await fetch(url,{
      method: 'GET',
      headers: {
        'Accept': 'application/json',
        'Content-Type': 'application/json',
      }
    });
    var responseJson = await response.json();
    return responseJson.movies;
  }
  render() {
    return (
      <View style={{flex: 1, marginTop: 25}}>
        <FlatList
          data={this.state.movies}
          renderItem={({item}) => <Text style={{fontSize: 30}}>{item.title}</Text>}
        />
      </View>
    )
  }
}