import React from 'react';
import { Text, View } from 'react-native';

export default class App extends React.Component {
  constructor(props){
    super(props);
    this.state = {moviesUI: []};
  }
  componentDidMount(){
    this.getMoviesFromAPI().then(function(movies){
      if((typeof movies == "object")&&(movies instanceof Array)){
        var moviesUI = [];
        for(let i=0; i<movies.length; i++){
          moviesUI.push(<Text style={{fontSize:30}} key={i}>{movies[i].title}</Text>)
        }
        this.setState({moviesUI: moviesUI});
      }
    }.bind(this)).catch(function(exception){
      alert("Exception: '" + exception + "'");
    });
  }
  async getMoviesFromAPI(){
    var url =  'https://facebook.github.io/react-native/movies.json';
    var response = await fetch(url,{
      method: 'GET',
      headers: {
        'Accept': 'application/json',
        'Content-Type': 'application/json',
      }
    });
    var responseJson = await response.json();
    return responseJson.movies;
  }
  render() {
    return (
      <View style={{flex: 1, marginTop: 25}}>
        {this.state.moviesUI}
      </View>
    )
  }
}