import React from 'react';
import { AsyncStorage, StyleSheet, TouchableOpacity, Text, View } from 'react-native';

export default class App extends React.Component {
  constructor(props){
    super(props);
    this.state = {counter: 0};
    this._loadState();
  }
  _increaseCounter(){
    this.setState({counter: (this.state.counter+1)});
  }
  _resetCounter(){
    this.setState({counter: 0});
  }
  async _saveState(){
    try {
      var currentState = JSON.stringify(this.state);
      await AsyncStorage.setItem('@HelloWorld:state',currentState);
    } catch (error) {
      // Error saving state
    }
  }
  async _loadState(){
    try {
      var storedState = await AsyncStorage.getItem('@HelloWorld:state');
      if (storedState !== null){
        var state = JSON.parse(storedState);
        this.setState(state);
      }
    } catch (error) {
      // Error retrieving state
    }
  }
  async _removeState(){
    try {
      await AsyncStorage.removeItem('@HelloWorld:state');
    } catch (error) {
      // Error removing state
    }
  }
  render(){
    return (
      <View style={{ flex:1, alignItems:'stretch', justifyContent:'flex-start' }}>
        <Text style={{fontSize: 50}}>Counter: {this.state.counter}</Text>
        <TouchableOpacity  onPress={this._increaseCounter.bind(this)}>
          <Text style={styles.button}>Increase counter</Text>
        </TouchableOpacity>
        <TouchableOpacity  onPress={this._resetCounter.bind(this)}>
          <Text style={styles.button}>Reset counter</Text>
        </TouchableOpacity>
        <TouchableOpacity  onPress={this._saveState.bind(this)}>
          <Text style={styles.button}>Save state</Text>
        </TouchableOpacity>
        <TouchableOpacity  onPress={this._loadState.bind(this)}>
          <Text style={styles.button}>Load stored state</Text>
        </TouchableOpacity>
        <TouchableOpacity  onPress={this._removeState.bind(this)}>
          <Text style={styles.button}>Remove stored state</Text>
        </TouchableOpacity>
      </View>
    )
  }
}

var styles = StyleSheet.create({
  button: {
    fontSize: 25,
    color: 'black',
    borderWidth: 5,
    borderRadius: 5,
    padding: 5,
    paddingLeft: 10,
    margin: 5,
    borderColor: 'black'
  }
});