import React from 'react';
import { Text, View } from 'react-native';

export default class App extends React.Component {
  constructor(props){
    super(props);
    this.state = {text: "Hello World"};
  }
  componentDidMount(){
    this._getNewText().then(function(newText){
      this.setState({text: newText});
    }.bind(this));
  }
  async _getNewText(){
    var newText = await this._fetchNewText();
    return newText;
  }
  async _fetchNewText(){
    return new Promise((resolve) => {
      // Simulate async operation
      setTimeout(function(){
        resolve("Goodbye World");
      },1500);
    })
  }
  render() {
    return (
      <View style={{ flex:1, alignItems:'center', justifyContent:'flex-start' }}>
        <Text style={{fontSize:30}}>{this.state.text}</Text>
      </View>
    )
  }
}