import React from 'react';
import { Vibration, TouchableHighlight, StyleSheet, Text, View } from 'react-native';

export default class App extends React.Component {
  _vibrate(){
    Vibration.vibrate(3000);
    // Android: the device will vibrate for 3s
    // iOS: duration is not configurable, so the device will vibrate for a fixed time (about 500ms)
  }
  _cancelVibration(){
    Vibration.cancel(); 
    //Stop vibration (Android and iOS)
  }
  render() {
    return (
      <View style={{ flex:1, alignItems:'center', justifyContent:'center' }}>
        <TouchableHighlight onPress={this._vibrate}>
          <Text style={styles.text}>Tap me to vibrate</Text>
        </TouchableHighlight>
        <TouchableHighlight onPress={this._cancelVibration}>
          <Text style={styles.text}>Tap me to cancel vibration</Text>
        </TouchableHighlight>
      </View>
    )
  }
}

const styles = StyleSheet.create({
    text: {
        padding: 15,
        margin: 10,
        backgroundColor: 'white',
        color: 'black',
        borderWidth: 3,
        borderColor: 'black',
        fontSize: 30,
        textAlign: 'center'
    }
})