import React from 'react';
import { Text, TextInput, View } from 'react-native';

export default class App extends React.Component {
  constructor(props){
    super(props);
    this.state = {value: ""};
  }
  _onTextInputChange(text){
    this.setState({value: text});
  }
  render() {
    return (
      <View>
        <TextInput style={{height: 80, fontSize: 30}} placeholder="Type here" onChangeText={this._onTextInputChange.bind(this)}/>
        <Text style={{fontSize: 30}}>Word count:</Text>
        <Text style={{fontSize: 30}}>{this.state.value.split(/\s+/).filter((w) => w!="").length}</Text>
      </View>
    )
  }
}