import React from 'react';
import { Slider, Text, View } from 'react-native';

export default class App extends React.Component {
  constructor(props) {
    super(props);
    this.state = {sliderValue:50, squareSide:50};
  }
  _onSliderValueChange(value){
    this.setState({sliderValue: value});
  }
  _onSlidingComplete(value){
    this.setState({squareSide:this.state.sliderValue});
  }  
  render() {    
    return (
       <View style={{flex:1, alignItems:'center', justifyContent:'flex-start', padding:25}}>
        <Slider
         style={{alignSelf:'stretch'}}
         step={1}
         minimumValue={20}
         maximumValue={80}
         value={this.state.sliderValue}
         onValueChange={this._onSliderValueChange.bind(this)}
         onSlidingComplete={this._onSlidingComplete.bind(this)}
        />
        <Text style={{fontSize: 25, padding: 30}}>{this.state.sliderValue}</Text>
        <View style={{width:this.state.squareSide, height:this.state.squareSide, backgroundColor:'purple'}}/>
      </View>
    )
  }
}