import React from 'react';
import { CheckBox, Text, TextInput, View } from 'react-native';

export default class App extends React.Component {
  constructor(props){
    super(props);
    this.state = {checkBoxValue: false};
  }
  _onCheckBoxValueChange(value){
    this.setState({checkBoxValue: value});
  }
  render() {
    return (
      <View style={{flex:1, alignItems:'stretch'}}>
        <CheckBox
          value={this.state.checkBoxValue}
          onValueChange={this._onCheckBoxValueChange.bind(this)}
          style={{alignSelf:'flex-start', margin: 10}} />
        <TextInput 
          editable={this.state.checkBoxValue}
          style={{height:80, padding:10, fontSize:25}} 
          placeholder='Check the CheckBox to type' />
      </View>
    )
  }
}