import React from 'react';
import { CameraRoll, FlatList, Image, TouchableHighlight, StyleSheet, Text, View } from 'react-native';

export default class App extends React.Component {
  constructor(props){
    super(props);
    this.state = {images: []}
  }
  _onPressButton(){
    CameraRoll.getPhotos({
      first: 20,
      assetType: 'Photos'
    }).then(r => this._onGetPhotos(r.edges));
  }
  _onGetPhotos(photos){
    var images = photos.map((asset) => {
      let image = asset.node.image;
      image.key = image.uri;
      return image;
    });
    this.setState({images: images});
  }
  _renderItem({item}){
    return (
      <View>
        <Image style={styles.image} source={{ uri: item.uri }}/>
      </View>
    )
  }
  render() {
    return (
      <View style={{ flex:1, alignItems:'flex-start', justifyContent:'flex-start' }}>
        <TouchableHighlight onPress={this._onPressButton.bind(this)}>
          <Text style={styles.text}>Load photos from Camera Roll</Text>
        </TouchableHighlight>
        <FlatList
          data={this.state.images}
          renderItem={this._renderItem.bind(this)}
        />
      </View>
    )
  }
}

const styles = StyleSheet.create({
    text: {
        padding: 15,
        margin: 10,
        backgroundColor: 'white',
        color: 'black',
        borderWidth: 3,
        borderColor: 'black',
        fontSize: 30,
        textAlign: 'center'
    },
    image: {
      width: 100,
      height: 100,
      margin: 10,
      borderWidth: 5,
      borderColor: 'black'
    }
})