import React from 'react';
import { Alert, StyleSheet, Text, TouchableHighlight, View } from 'react-native';

export default class App extends React.Component {
  _onPressButton(){
    Alert.alert(
      "Alert",
      "This is an alert with two buttons: 'OK' and 'Cancel'",
      [
        {text: 'OK', onPress: () => console.log('OK pressed')},
        {text: 'Cancel', onPress: () => console.log('Cancel pressed')}
      ],
      { cancelable: false }
    )
  }
  render() {
    return (
      <View>
        <TouchableHighlight onPress={this._onPressButton}>
          <Text style={styles.text}>Tap me to show an alert</Text>
        </TouchableHighlight>
      </View>
    )
  }
}

const styles = StyleSheet.create({
    text: {
        padding: 15,
        margin: 10,
        backgroundColor: 'white',
        color: 'black',
        borderWidth: 3,
        borderColor: 'black',
        fontSize: 25,
        textAlign: 'center'
    }
})