import React from 'react';
import { Text, TextInput, TouchableHighlight, View } from 'react-native';

export default class App extends React.Component {
  constructor(props){
    super(props);
    this.state = {valueText: "Hello World!", valueTextInput: ""}
  }
  _onTextInputChange(text){
    this.setState({valueTextInput: text});
  }
  _onPressButton(){
    this.setState({valueText: this.state.valueTextInput});
  }
  render() {
    return (
      <View style={{
        flex:1, 
        flexDirection:'column',
        alignItems:'center', 
        justifyContent:'center'
      }}>
        <Text style={{fontSize:25}}>{this.state.valueText}</Text>
        <TextInput style={{height:70, alignSelf: 'stretch', fontSize:25, padding:5}}
         onChangeText={this._onTextInputChange.bind(this)}/>
        <TouchableHighlight onPress={this._onPressButton.bind(this)}>
          <Text style={{fontSize:25}}>Replace text</Text>
        </TouchableHighlight>
      </View>
    )
  }
}